/*
 * Decompiled with CFR 0.152.
 */
package pkg_list;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;
import pkg_list.ListVal;
import pkg_list.ListVals;

public class ListPage {
    public long type;
    public final TreeMap<Long, ListVal> map;

    public ListPage() {
        this.type = 0L;
        this.map = new TreeMap();
    }

    public ListPage(long type) {
        this.type = type;
        this.map = new TreeMap();
    }

    public ListPage(long type, TreeMap<Long, ListVal> map) {
        this.type = type;
        this.map = map;
    }

    public void put(long key, ListVal value) {
        this.map.put(key, value);
    }

    public void put(long key, int ... value) {
        ByteBuffer b = ByteBuffer.allocate(4 * value.length);
        for (int i = 0; i < value.length; ++i) {
            b.putInt(value[i]);
        }
        this.map.put(key, new ListVal(b.array(), 3));
    }

    public void put(long key, boolean ... value) {
        byte[] a = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            a[i] = (byte)(value[i] ? 1 : 0);
        }
        this.map.put(key, new ListVal(a, 1));
    }

    public void put(long key, byte ... value) {
        this.map.put(key, new ListVal(value, 0));
    }

    public void put(long key, short ... value) {
        ByteBuffer b = ByteBuffer.allocate(2 * value.length);
        for (int i = 0; i < value.length; ++i) {
            b.putShort(value[i]);
        }
        this.map.put(key, new ListVal(b.array(), 2));
    }

    public void put(long key, long ... value) {
        ByteBuffer b = ByteBuffer.allocate(8 * value.length);
        for (int i = 0; i < value.length; ++i) {
            b.putLong(value[i]);
        }
        this.map.put(key, new ListVal(b.array(), 5));
    }

    public void put(long key, float ... value) {
        ByteBuffer b = ByteBuffer.allocate(4 * value.length);
        for (int i = 0; i < value.length; ++i) {
            b.putFloat(value[i]);
        }
        this.map.put(key, new ListVal(b.array(), 4));
    }

    public void put(long key, double ... value) {
        ByteBuffer b = ByteBuffer.allocate(8 * value.length);
        for (int i = 0; i < value.length; ++i) {
            b.putDouble(value[i]);
        }
        this.map.put(key, new ListVal(b.array(), 6));
    }

    public void put(long key, String value) {
        this.put(key, value, 8, StandardCharsets.UTF_8);
    }

    public void put(long key, String ... value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (value[i] != null) {
                builder.append(value[i]);
            }
            builder.append('\u0000');
        }
        this.put(key, builder.toString(), 8, StandardCharsets.UTF_8);
    }

    public void put(long key, String value, int type, Charset charset) {
        this.map.put(key, new ListVal(value.getBytes(charset), type));
    }

    public long raw_size() {
        long size = 16L;
        for (ListVal value : this.map.values()) {
            size += 8L + (long)value.bytes.length + 1L + (long)((int)(value.bytes.length == 0 ? 1.0 : Math.log(value.bytes.length) / Math.log(256.0) + 1.0));
        }
        return size;
    }

    private int value_encode_size(int length) {
        return length == 0 ? 1 : length + 1 + (int)(Math.log(length) / Math.log(2.0) + 1.0);
    }

    public int encode_size() {
        return (int)(Math.log(this.raw_size()) / Math.log(2.0) + 1.0);
    }

    public String toString() {
        return this.type + this.map.toString();
    }

    public int[] getInts(long key) throws BufferUnderflowException {
        return ListVals.getInts(this.map.get((Object)Long.valueOf((long)key)).bytes);
    }

    public float[] getFloats(long key) throws BufferUnderflowException {
        return ListVals.getFloats(this.map.get((Object)Long.valueOf((long)key)).bytes);
    }

    public double[] getDoubles(long key) throws BufferUnderflowException {
        return ListVals.getDoubles(this.map.get((Object)Long.valueOf((long)key)).bytes);
    }

    public long[] getLongs(long key) throws BufferUnderflowException {
        return ListVals.getLongs(this.map.get((Object)Long.valueOf((long)key)).bytes);
    }

    public byte[] getBytes(long key) {
        return ListVals.getBytes(this.map.get((Object)Long.valueOf((long)key)).bytes);
    }

    public short[] getShorts(long key) throws BufferUnderflowException {
        return ListVals.getShorts(this.map.get((Object)Long.valueOf((long)key)).bytes);
    }

    public boolean[] getBooleans(long key) {
        return ListVals.getBooleans(this.map.get((Object)Long.valueOf((long)key)).bytes);
    }

    public boolean[] getBits(long key) throws BufferUnderflowException {
        return ListVals.getBits(this.map.get((Object)Long.valueOf((long)key)).bytes);
    }

    public String getString(long key) {
        return ListVals.getString(this.map.get((Object)Long.valueOf((long)key)).bytes);
    }

    public String getString(long key, Charset charset) {
        return ListVals.getString(this.map.get((Object)Long.valueOf((long)key)).bytes, charset);
    }

    public int[] parseInts(long key) throws NumberFormatException {
        return this.parseInts(key, " ");
    }

    public float[] parseFloats(long key) throws NumberFormatException {
        return this.parseFloats(key, " ");
    }

    public double[] parseDoubles(long key) throws NumberFormatException {
        return this.parseDoubles(key, " ");
    }

    public long[] parseLongs(long key) throws NumberFormatException {
        return this.parseLongs(key, " ");
    }

    public byte[] parseBytes(long key) throws NumberFormatException {
        return this.parseBytes(key, " ");
    }

    public short[] parseShorts(long key) throws NumberFormatException {
        return this.parseShorts(key, " ");
    }

    public boolean[] parseBooleans(long key) throws NumberFormatException {
        return this.parseBooleans(key, " ");
    }

    public int[] parseInts(long key, String splitRegex) throws NumberFormatException {
        String[] s = this.getString(key).split(splitRegex);
        int[] ints = new int[s.length];
        for (int i = 0; i < s.length; ++i) {
            ints[i] = Integer.parseInt(s[i]);
        }
        return ints;
    }

    public float[] parseFloats(long key, String splitRegex) throws NumberFormatException {
        String[] s = this.getString(key).split(splitRegex);
        float[] floats = new float[s.length];
        for (int i = 0; i < s.length; ++i) {
            floats[i] = Float.parseFloat(s[i]);
        }
        return floats;
    }

    public double[] parseDoubles(long key, String splitRegex) throws NumberFormatException {
        String[] s = this.getString(key).split(splitRegex);
        double[] doubles = new double[s.length];
        for (int i = 0; i < s.length; ++i) {
            doubles[i] = Double.parseDouble(s[i]);
        }
        return doubles;
    }

    public long[] parseLongs(long key, String splitRegex) throws NumberFormatException {
        String[] s = this.getString(key).split(splitRegex);
        long[] longs = new long[s.length];
        for (int i = 0; i < s.length; ++i) {
            longs[i] = Long.parseLong(s[i]);
        }
        return longs;
    }

    public byte[] parseBytes(long key, String splitRegex) throws NumberFormatException {
        String[] s = this.getString(key).split(splitRegex);
        byte[] bytes = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            bytes[i] = Byte.parseByte(s[i]);
        }
        return bytes;
    }

    public short[] parseShorts(long key, String splitRegex) throws NumberFormatException {
        String[] s = this.getString(key).split(splitRegex);
        short[] shorts = new short[s.length];
        for (int i = 0; i < s.length; ++i) {
            shorts[i] = Short.parseShort(s[i]);
        }
        return shorts;
    }

    public boolean[] parseBooleans(long key, String splitRegex) throws NumberFormatException {
        String[] s = this.getString(key).split(splitRegex);
        boolean[] booleans = new boolean[s.length];
        for (int i = 0; i < s.length; ++i) {
            booleans[i] = Boolean.parseBoolean(s[i]);
        }
        return booleans;
    }

    public boolean[] parseBits(long key) throws NumberFormatException {
        String s = this.getString(key);
        boolean[] booleans = new boolean[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '0' && c != '1') {
                throw new NumberFormatException();
            }
            booleans[i] = c == '1';
        }
        return booleans;
    }

    public String[] getWords(long key) {
        return this.getWords(key, " ");
    }

    public String[] getWords(long key, String splitRegex) {
        return this.getWords(key, splitRegex, StandardCharsets.UTF_8);
    }

    public String[] getWords(long key, String splitRegex, Charset charset) {
        return this.getString(key, charset).split(splitRegex);
    }
}

