/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_graphic.BigLabel;
import pkg_graphic.Executable;
import pkg_graphic.Frame;
import pkg_graphic.Menubar;
import pkg_ixe.Ixe;
import pkg_ixe.IxeDialog;
import pkg_ixe.IxeMeta;
import pkg_list.ListDecoder;
import pkg_list.ListPage;
import pkg_list.ListVal;
import pkg_list.ListVals;
import pkg_list.Lists;
import pkg_logic.ExecThread;

public class Window
extends Frame
implements ListSelectionListener {
    JPanel launcher_panel;
    JLabel lbl_name = new JLabel();
    JLabel lbl_version = new JLabel();
    JLabel lbl_created_at = new JLabel();
    JLabel lbl_updated_at = new JLabel();
    BigLabel lbl_description = new BigLabel();
    JLabel lbl_command = new JLabel();
    JButton btn_run = new JButton();
    Executable candidate = null;
    JCheckBox toggle_fullscreen = new JCheckBox("Fullscreen");
    private DefaultListModel list_model = new DefaultListModel();
    private JList launch_list = new JList(this.list_model);
    ArrayList<Executable> candidates = new ArrayList();

    public Window(String title) {
        super(title);
        this.setLayout(new GridBagLayout());
        JScrollPane scroller = new JScrollPane(this.launch_list);
        this.launch_list.addListSelectionListener(this);
        JPanel right_panel = new JPanel(new BorderLayout());
        this.launcher_panel = new JPanel(new BorderLayout());
        JPanel meta_panel = new JPanel(new GridLayout(2, 1));
        meta_panel.setBorder(new EmptyBorder(15, 30, 15, 30));
        JPanel meta_subpanels_pack = new JPanel(new BorderLayout());
        JPanel meta_subpanels = new JPanel(new BorderLayout());
        JPanel meta_subpanel1 = new JPanel(new GridLayout(4, 1));
        meta_subpanel1.setBorder(new EmptyBorder(0, 0, 0, 15));
        JPanel meta_subpanel2 = new JPanel(new GridLayout(4, 1));
        meta_subpanel1.add(new JLabel("Name", 0));
        meta_subpanel2.add(this.lbl_name);
        meta_subpanel1.add(new JLabel("Version", 0));
        meta_subpanel2.add(this.lbl_version);
        meta_subpanel1.add(new JLabel("Created at", 0));
        meta_subpanel2.add(this.lbl_created_at);
        meta_subpanel1.add(new JLabel("Updated at", 0));
        meta_subpanel2.add(this.lbl_updated_at);
        meta_subpanels.add((Component)meta_subpanel1, "West");
        meta_subpanels.add((Component)meta_subpanel2, "Center");
        meta_subpanels_pack.add((Component)meta_subpanels, "North");
        JScrollPane scroller_meta = new JScrollPane(meta_subpanels_pack);
        JScrollPane scroller_desc = new JScrollPane(this.lbl_description);
        meta_panel.add(scroller_meta);
        meta_panel.add(scroller_desc);
        this.launcher_panel.add((Component)meta_panel, "Center");
        JPanel pnl_run = new JPanel(new GridLayout(2, 1));
        JPanel pnl_command = new JPanel(new BorderLayout());
        this.toggle_fullscreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.update_command();
            }
        });
        pnl_command.add((Component)this.lbl_command, "Center");
        pnl_command.add((Component)this.toggle_fullscreen, "East");
        pnl_run.add(pnl_command);
        pnl_run.add(this.btn_run);
        this.launcher_panel.add((Component)pnl_run, "South");
        right_panel.add((Component)this.launcher_panel, "Center");
        this.btn_run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (Window.this.candidate != null) {
                    ExecThread thread = Window.this.candidate.get_thread();
                    if (thread != null) {
                        thread.request_close();
                        Window.this.btn_run.setText("Run");
                        Window.this.btn_run.setEnabled(false);
                    } else if (thread == null) {
                        thread = new ExecThread(Window.this.candidate, Window.this.toggle_fullscreen.isSelected());
                        Window.this.candidate.set_thread(thread);
                        thread.start();
                        Window.this.btn_run.setText("Stop");
                    }
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)scroller, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 2.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)right_panel, c);
        this.setJMenuBar(new Menubar(this));
        this.auto();
        this.fullscreen();
        this.update_content();
        this.setVisible(true);
    }

    private void auto() {
        this.auto_file = new File("auto.list");
        if (this.auto_file.exists() && this.auto_file.isFile()) {
            try {
                this.file = this.auto_file;
                this.load_data(ListDecoder.open(this.file));
            }
            catch (IOException e) {
                IxeDialog.error("Cannot load " + this.file + "\n" + e.getMessage());
                this.load_data(null);
            }
        }
    }

    private void update_command() {
        String name = this.candidate == null ? "" : this.candidate.get_file().getAbsolutePath();
        this.lbl_command.setText("java -jar " + name + " fullscreen=" + (this.toggle_fullscreen.isSelected() ? 1 : 0));
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        if (this.list_model.size() != this.candidates.size()) {
            this.update_list();
        }
        if (this.candidate != null && this.candidate.get_thread() != null && this.candidate.get_thread().has_exit_code()) {
            this.candidate.set_thread(null);
            this.btn_run.setEnabled(true);
        }
    }

    @Override
    public void load_data(Lists data) {
        this.candidates.clear();
        try {
            ListPage p = data.get_page(0L);
            for (ListVal v : p.map.values()) {
                this.make_candidate(new File(v.str()));
            }
        }
        catch (Exception e) {
            IxeDialog.error(e.getMessage());
        }
        this.update_list();
        this.select_executable(0);
    }

    @Override
    public Lists parse() {
        Lists data = new Lists();
        ListPage p0 = new ListPage(0L);
        data.add_page(p0);
        long id = 0L;
        for (Executable e : this.candidates) {
            if (e == null || e.get_file() == null) continue;
            p0.put(id++, new ListVal(ListVal.VALTYPE.UTF8, ListVals.parseBytes_str(e.get_file().getAbsolutePath(), StandardCharsets.UTF_8)));
        }
        return data;
    }

    private void update_list() {
        this.list_model.clear();
        for (Executable c : this.candidates) {
            this.list_model.addElement(c.get_name());
        }
        this.launch_list.validate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.candidate = this.launch_list.getSelectedIndex() != -1 && !this.candidates.isEmpty() ? this.candidates.get(Ixe.safe_index(this.launch_list.getSelectedIndex(), this.candidates.size())) : null;
            this.update_content();
        }
    }

    private void update_content() {
        if (this.candidate == null) {
            this.launcher_panel.setVisible(false);
        } else {
            this.lbl_name.setText(this.candidate.get_name());
            this.lbl_version.setText(this.candidate.get_version());
            this.lbl_created_at.setText(this.candidate.get_time());
            this.lbl_updated_at.setText(this.candidate.get_time_modified());
            this.lbl_description.setText(this.candidate.get_description());
            this.btn_run.setText(this.candidate.get_thread() == null ? "Run" : "Stop");
            this.btn_run.setEnabled(this.candidate.get_thread() == null || !this.candidate.get_thread().has_request_close());
            this.update_command();
            this.launcher_panel.setVisible(true);
        }
    }

    public void select_executable(int type) {
        if (!this.list_model.isEmpty()) {
            switch (type) {
                case 0: {
                    this.launch_list.setSelectedIndex(0);
                    break;
                }
                case 1: {
                    this.launch_list.setSelectedIndex(Ixe.clamp(this.launch_list.getSelectedIndex() - 1, 0, this.list_model.size() - 1));
                    break;
                }
                case 2: {
                    this.launch_list.setSelectedIndex(Ixe.clamp(this.launch_list.getSelectedIndex() + 1, 0, this.list_model.size() - 1));
                    break;
                }
                case 3: {
                    this.launch_list.setSelectedIndex(this.list_model.size() - 1);
                }
            }
        }
    }

    public void move_executable(int type) {
        if (!this.list_model.isEmpty() && this.launch_list.getSelectedIndex() != -1) {
            int index = this.launch_list.getSelectedIndex();
            Executable e = this.candidates.get(index);
            this.candidates.remove(index);
            int next_index = index;
            switch (type) {
                case 0: {
                    next_index = 0;
                    break;
                }
                case 1: {
                    next_index = index > 0 ? index - 1 : 0;
                    break;
                }
                case 2: {
                    next_index = index < this.candidates.size() ? index + 1 : this.candidates.size();
                    break;
                }
                case 3: {
                    next_index = this.candidates.size();
                }
            }
            this.candidates.add(next_index, e);
            this.update_list();
            this.launch_list.setSelectedIndex(next_index);
        }
    }

    public void executable_add() {
        int returnVal = fc_exec.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc_exec.getSelectedFile();
            try {
                int file_index = this.find_file(file);
                if (file_index != -1) {
                    this.launch_list.setSelectedIndex(file_index);
                } else {
                    this.make_candidate(file);
                    this.update_list();
                    this.select_executable(4);
                }
            }
            catch (Exception e) {
                IxeDialog.error("Cannot load " + file + "\n" + e.getMessage());
            }
        }
    }

    protected void make_candidate(File file) {
        Executable candidate = new Executable(file);
        this.identify_candidate(candidate);
        this.candidates.add(candidate);
    }

    private int find_file(File file) {
        for (int i = 0; i < this.candidates.size(); ++i) {
            if (!this.candidates.get(i).get_file().getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath())) continue;
            return i;
        }
        return -1;
    }

    private void identify_candidate(Executable executable) {
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            System.out.println(executable.get_file().getAbsolutePath());
            ProcessBuilder processBuilder = new ProcessBuilder("java", "-jar", executable.get_file().getAbsolutePath());
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            System.out.println("___________");
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
            process.waitFor(5L, TimeUnit.SECONDS);
            process.destroy();
            process.waitFor(10L, TimeUnit.SECONDS);
            process.destroyForcibly();
            int n = process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        String[] meta = IxeMeta.parse(builder.toString(), new String[]{"name", "description", "time", "time-modified", "version-major", "version-minor"});
        for (int i = 0; i < meta.length; ++i) {
            System.out.println("**" + meta[i]);
        }
        executable.set_name(meta[0]);
        executable.set_description(meta[1]);
        executable.set_time(meta[2]);
        executable.set_time_modified(meta[3]);
        executable.set_version_major(meta[4]);
        executable.set_version_minor(meta[5]);
    }

    public void executable_remove() {
        int index = this.launch_list.getSelectedIndex();
        if (index != -1) {
            this.candidates.remove(index);
            this.update_list();
        }
    }

    public boolean stop() {
        this.btn_run.setEnabled(false);
        boolean stop = true;
        for (int i = 0; i < this.candidates.size(); ++i) {
            ExecThread thread = this.candidates.get(i).get_thread();
            if (thread == null) continue;
            if (thread.has_exit_code()) {
                this.candidates.get(i).set_thread(null);
                continue;
            }
            thread.request_close();
            stop = false;
        }
        return stop;
    }
}

