/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import java.util.Random;
import pkg_data.Data1D;
import pkg_data.Data2D;
import pkg_data.LanguageData;
import pkg_ixe.IxeArray;
import pkg_ixe.IxeLang;

public class Generator {
    private static Random random = new Random();

    public static void seed(long seed) {
        random.setSeed(seed);
    }

    public static String generate(boolean sign, int digits, int radix) {
        if (digits <= 0 || radix < 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder(sign && random.nextBoolean() ? "-" : "");
        for (int i = 0; i < digits; ++i) {
            int x = i == 0 ? random.nextInt(radix - 1) + 1 : random.nextInt(radix);
            char c = (char)(x < 10 ? 48 + x : 65 + (x - 10));
            builder.append(c);
        }
        return builder.toString();
    }

    public static String generate(String format) {
        StringBuilder builder = new StringBuilder();
        block2: for (int i = 0; i < format.length(); ++i) {
            char c2;
            char c = format.charAt(i);
            char c3 = c2 = i < format.length() - 1 ? (char)format.charAt(i + 1) : (char)' ';
            if (c == '\\' && (c2 == '+' || IxeLang.digit(c2))) {
                builder.append(c2);
                ++i;
                continue;
            }
            if (IxeLang.digit(c)) {
                while (i <= format.length()) {
                    int type = -1;
                    int base = -1;
                    int range = -1;
                    boolean next = false;
                    for (int j = i + 1; j <= format.length(); ++j) {
                        char c32 = j < format.length() ? (char)format.charAt(j) : (char)' ';
                        boolean append = false;
                        boolean step_out = false;
                        if (c32 == ',') {
                            append = true;
                        } else if (c32 == '+') {
                            next = true;
                            append = true;
                            step_out = true;
                        } else if (!IxeLang.digit(c32)) {
                            append = true;
                            step_out = true;
                        }
                        if (!append) continue;
                        if (i < j) {
                            int value;
                            try {
                                value = Integer.parseInt(format.substring(i, j));
                            }
                            catch (Exception e) {
                                return "";
                            }
                            if (type == -1) {
                                type = value;
                            } else if (base == -1) {
                                base = value;
                            } else if (range == -1) {
                                range = value;
                                step_out = true;
                            }
                        }
                        if (step_out) {
                            i = next ? j + 1 : j - 1;
                            break;
                        }
                        i = j + 1;
                    }
                    if (type == -1 || type > 10 || base < -1 || range < -1) {
                        return "";
                    }
                    if (base == -1) {
                        base = 1;
                    }
                    if (range == -1) {
                        range = 0;
                    }
                    int length = random.nextInt(range + 1) + base;
                    for (int k = 0; k < length; ++k) {
                        builder.append(Generator.gen_char(type));
                    }
                    if (next) continue;
                    continue block2;
                }
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static char gen_char(int type) {
        char c = ' ';
        int r = 0;
        switch (type) {
            case 0: {
                r = random.nextInt(IxeLang.txt_SPECIAL.length + 62);
                if (r < IxeLang.txt_SPECIAL.length) {
                    c = IxeLang.txt_SPECIAL[r];
                    break;
                }
                if (r < IxeLang.txt_SPECIAL.length + 26) {
                    c = (char)(65 + r - IxeLang.txt_SPECIAL.length);
                    break;
                }
                if (r < IxeLang.txt_SPECIAL.length + 52) {
                    c = (char)(97 + r - IxeLang.txt_SPECIAL.length - 26);
                    break;
                }
                c = (char)(48 + r - IxeLang.txt_SPECIAL.length - 52);
                break;
            }
            case 1: {
                r = random.nextInt(62);
                if (r < 26) {
                    c = (char)(65 + r);
                    break;
                }
                if (r < 52) {
                    c = (char)(97 + r - 26);
                    break;
                }
                c = (char)(48 + r - 52);
                break;
            }
            case 2: {
                c = IxeLang.txt_SPECIAL[random.nextInt(IxeLang.txt_SPECIAL.length)];
                break;
            }
            case 3: {
                c = (char)((random.nextBoolean() ? 97 : 65) + random.nextInt(26));
                break;
            }
            case 4: {
                c = (char)(97 + random.nextInt(26));
                break;
            }
            case 5: {
                c = (char)(65 + random.nextInt(26));
                break;
            }
            case 6: {
                c = (char)(IxeLang.txt_CONSONANT[random.nextInt(IxeLang.txt_CONSONANT.length)] + 32);
                break;
            }
            case 7: {
                c = IxeLang.txt_CONSONANT[random.nextInt(IxeLang.txt_CONSONANT.length)];
                break;
            }
            case 8: {
                c = (char)(IxeLang.txt_VOWEL[random.nextInt(IxeLang.txt_VOWEL.length)] + 32);
                break;
            }
            case 9: {
                c = IxeLang.txt_VOWEL[random.nextInt(IxeLang.txt_VOWEL.length)];
                break;
            }
            case 10: {
                c = (char)(48 + random.nextInt(10));
            }
        }
        return c;
    }

    public static String generate(CATEGORY category) {
        String[] values = null;
        switch (category.ordinal()) {
            case 2: {
                values = Data1D.d1d_COUNTRIES;
                break;
            }
            case 3: {
                values = Data1D.d1d_LANGUAGES;
                break;
            }
            case 5: {
                values = Data1D.d1d_ATOMS;
                break;
            }
            case 6: {
                values = Data1D.d1d_COLORS;
                break;
            }
            case 7: {
                values = Data1D.d1d_ORGANS;
                break;
            }
            case 8: {
                values = Data1D.d1d_FOODS;
                break;
            }
            case 9: {
                values = Data1D.d1d_OBJECTS;
                break;
            }
            case 10: {
                values = Data1D.d1d_VERBS;
                break;
            }
            case 11: {
                values = Data1D.d1d_PLANTS;
                break;
            }
            case 12: {
                values = Data1D.d1d_ZODIAC;
                break;
            }
            case 13: {
                values = Data1D.d1d_WATERS;
                break;
            }
            case 14: {
                values = Data1D.d1d_CELESTIALS;
                break;
            }
            case 15: {
                values = Data1D.d1d_CALENDAR;
                break;
            }
            case 16: {
                values = Data1D.d1d_DAY;
                break;
            }
            case 17: {
                values = Data1D.d1d_MOUNTAINS;
                break;
            }
            case 18: {
                values = Data1D.d1d_ISLANDS;
                break;
            }
            case 19: {
                values = Data1D.d1d_ECOREGIONS;
            }
        }
        if (values != null) {
            return values[random.nextInt(values.length)];
        }
        return "";
    }

    public static String generate(CATEGORY category, int subcategory) {
        String[] values = null;
        String suffix = "";
        switch (category.ordinal()) {
            case 0: {
                if (subcategory == 0) {
                    values = Data2D.d2d_NAMES[random.nextInt(Data2D.d2d_NAMES.length)];
                    break;
                }
                if (subcategory - 1 >= Data2D.d2d_NAMES.length) break;
                values = Data2D.d2d_NAMES[subcategory - 1];
                break;
            }
            case 1: {
                if (subcategory == 0) {
                    int country = random.nextInt(Data2D.d2d_CITIES.length);
                    values = Data2D.d2d_CITIES[country];
                    suffix = ", " + Data1D.d1d_COUNTRIES[country];
                    break;
                }
                if (subcategory - 1 >= Data2D.d2d_CITIES.length) break;
                values = Data2D.d2d_CITIES[subcategory - 1];
                break;
            }
            case 4: {
                if (subcategory == 0) {
                    values = Data2D.d2d_ANIMALS[random.nextInt(Data2D.d2d_ANIMALS.length)];
                    break;
                }
                if (subcategory == 1) {
                    values = Data2D.d2d_ANIMALS[random.nextInt(6)];
                    break;
                }
                if (subcategory - 2 >= Data2D.d2d_ANIMALS.length) break;
                values = Data2D.d2d_ANIMALS[subcategory - 2];
            }
        }
        if (values != null) {
            return values[random.nextInt(values.length)] + suffix;
        }
        return "";
    }

    public static String shuffle(String s) {
        StringBuilder builder = new StringBuilder();
        String[] split = s.split("\n+");
        int count = 0;
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
            if (split[i].isEmpty()) continue;
            ++count;
        }
        if (count > 0) {
            int i;
            String[] split2 = new String[count];
            count = 0;
            for (i = 0; i < split.length; ++i) {
                if (split[i].isEmpty()) continue;
                split2[count++] = split[i];
            }
            IxeArray.shuffle(split2, random);
            for (i = 0; i < split2.length; ++i) {
                if (i != 0) {
                    builder.append('\n');
                }
                builder.append(split2[i]);
            }
        }
        return builder.toString();
    }

    public static String generate_filler_words(int count, double[] frequency) {
        return Generator.generate_filler_words(count, false, frequency);
    }

    public static String generate_filler_words(int count, boolean sentence, double[] frequency) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                builder.append(' ');
            }
            int length = random.nextInt(7) + 2;
            for (int j = 0; j < length; ++j) {
                boolean capitalize = j == 0 && (!sentence || i == 0);
                builder.append(Generator.generate_char(capitalize, frequency));
            }
        }
        return builder.toString();
    }

    private static String generate_char(boolean capitalize, double[] frequency) {
        String character = "";
        double w = random.nextDouble() * frequency[frequency.length - 1];
        for (int i = 0; i < frequency.length; ++i) {
            if (!(frequency[i] >= w)) continue;
            character = LanguageData.letters[i];
            break;
        }
        if (character.length() > 0 && capitalize) {
            character = character.substring(0, 1).toUpperCase() + character.substring(1);
        }
        return character;
    }

    public static String generate_filler_sentences(int count, double[] frequency) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                builder.append(' ');
            }
            int length = random.nextInt(12) + 6;
            builder.append(Generator.generate_filler_words(length, true, frequency));
            builder.append('.');
        }
        return builder.toString();
    }

    public static String generate_filler_paragraphs(int count, double[] frequency) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                builder.append("\n\n");
            }
            int length = random.nextInt(10) + 4;
            builder.append(Generator.generate_filler_sentences(length, frequency));
        }
        return builder.toString();
    }

    public static enum CATEGORY {
        NAME(new String[]{"ALL", "MALE", "FEMALE"}),
        CITY(IxeArray.prefix(Data1D.d1d_COUNTRIES, "ALL")),
        COUNTRY(null),
        LANGUAGE(null),
        ANIMAL(new String[]{"ALL", "MAMMALS, ALL", "MAMMALS, RODENTS", "MAMMALS, BATS", "MAMMALS, PRIMATES", "MAMMALS, CARNIVORES", "MAMMALS, ARTYODACTYLES", "MAMMALS, OTHER", "FISH", "BIRD", "AMPHIBIAN", "INSECT", "REPTILE"}),
        ATOM(null),
        COLOR(null),
        ORGAN(null),
        FOOD(null),
        OBJECT(null),
        VERB(null),
        PLANT(null),
        ZODIAC(null),
        WATER(null),
        CELESTIAL(null),
        CALENDAR(null),
        DAY(null),
        MOUNTAIN(null),
        ISLAND(null),
        ECOREGION(null);

        public final String[] subcategories;

        private CATEGORY(String[] subcategories) {
            this.subcategories = subcategories;
        }
    }
}

