/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_data.LanguageData;
import pkg_graphic.Frame;
import pkg_graphic.Menubar;
import pkg_ixe.Ixe;
import pkg_ixe.IxeMath;
import pkg_logic.Generator;

public class Window
extends Frame {
    private Random seed_generator = new Random();
    private JTextField seed_input = new JTextField();
    private JLabel lbl_seed_count = new JLabel();
    private JButton btn_seed_reset = new JButton("Reset");
    private int seed_count = 0;
    private JCheckBox seed_box = new JCheckBox();
    private JTextField number_output = new JTextField();
    private JTextField number_digits = new JTextField();
    private JCheckBox number_sign = new JCheckBox();
    private JTextField number_radix = new JTextField();
    private JTextField query_input = new JTextField();
    private JTextField query_output = new JTextField();
    private JComboBox box_query = new JComboBox<String>(new String[]{"EMAIL", "ADDRESS", "POSTAL CODE", "TELEPHONE", "PASSWORD", "URL", "CUSTOM"});
    private JTextField category_output = new JTextField();
    private JComboBox box_category = new JComboBox<Generator.CATEGORY>(Generator.CATEGORY.values());
    private JComboBox box_subcategory = new JComboBox();
    private JComboBox box_filler;
    private JComboBox box_filler_language = new JComboBox<String>(LanguageData.language_names);
    private JTextField nb_filler;
    private JTextArea filler = new JTextArea();
    private JTextArea shuffler = new JTextArea();
    private JPanel panel_frequency = new JPanel(new GridLayout(LanguageData.letters.length, 2));
    private JTextField[] input_frequency = new JTextField[LanguageData.letters.length];
    private double[] frequency = new double[LanguageData.letters.length];

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.setJMenuBar(new Menubar(this));
        this.seed_input.setEnabled(false);
        this.seed_box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.seed(true);
            }
        });
        JButton btn_rand_seed = new JButton("?");
        btn_rand_seed.setMargin(new Insets(0, 0, 0, 0));
        btn_rand_seed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.random_seed();
            }
        });
        JLabel lbl_seed = new JLabel("Seed", 0);
        JPanel panel_seed_ctrl = new JPanel(new GridLayout(1, 3));
        panel_seed_ctrl.add(lbl_seed);
        panel_seed_ctrl.add(btn_rand_seed);
        panel_seed_ctrl.add(this.seed_box);
        JPanel panel_seed_count = new JPanel(new GridLayout(1, 2));
        this.btn_seed_reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.reset_seed();
            }
        });
        panel_seed_count.add(this.lbl_seed_count);
        panel_seed_count.add(this.btn_seed_reset);
        JPanel panel_seed = new JPanel(new BorderLayout());
        panel_seed.add((Component)this.seed_input, "Center");
        panel_seed.add((Component)panel_seed_ctrl, "West");
        panel_seed.add((Component)panel_seed_count, "East");
        JPanel panel_number = new JPanel(new BorderLayout());
        JPanel panel_number_ctrl = new JPanel(new GridLayout(1, 3));
        panel_number_ctrl.add(new JLabel("Number"));
        panel_number.add((Component)panel_number_ctrl, "West");
        panel_number.add((Component)this.number_output, "Center");
        JButton btn_number = new JButton("Number");
        btn_number.setMargin(new Insets(0, 0, 0, 0));
        btn_number.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.gen_number();
            }
        });
        JPanel panel_number_east = new JPanel(new GridLayout(1, 7));
        panel_number_east.add(new JLabel("Signed"));
        panel_number_east.add(this.number_sign);
        panel_number_east.add(new JLabel("Digits"));
        panel_number_east.add(this.number_digits);
        panel_number_east.add(new JLabel("Radix"));
        panel_number_east.add(this.number_radix);
        panel_number_east.add(btn_number);
        panel_number.add((Component)panel_number_east, "East");
        this.box_query.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = "";
                switch (Window.this.box_query.getSelectedIndex()) {
                    case 0: {
                        text = "1,4,8@mail.com";
                        break;
                    }
                    case 1: {
                        text = "10,1,4 5,1+4,4,6 street";
                        break;
                    }
                    case 2: {
                        text = "5+10+5 10+5+10";
                        break;
                    }
                    case 3: {
                        text = "10,3-10,3-10,4";
                        break;
                    }
                    case 4: {
                        text = "0,20";
                        break;
                    }
                    case 5: {
                        text = "http://www.4,4,12.com";
                        break;
                    }
                    case 6: {
                        text = "";
                    }
                }
                Window.this.query_input.setText(text);
            }
        });
        this.box_query.setSelectedIndex(0);
        JPanel panel_query = new JPanel(new BorderLayout());
        JPanel panel_query_ctrl = new JPanel(new GridLayout(1, 3));
        panel_query_ctrl.add(new JLabel("Query"));
        panel_query_ctrl.add(this.box_query);
        panel_query_ctrl.add(this.query_input);
        panel_query.add((Component)panel_query_ctrl, "West");
        panel_query.add((Component)this.query_output, "Center");
        JButton btn_query = new JButton("Query");
        btn_query.setMargin(new Insets(0, 0, 0, 0));
        btn_query.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.gen_query();
            }
        });
        panel_query.add((Component)btn_query, "East");
        JPanel panel_category = new JPanel(new BorderLayout());
        JPanel panel_category_ctrl = new JPanel(new GridLayout(1, 4));
        panel_category_ctrl.add(new JLabel("Category"));
        panel_category_ctrl.add(this.box_category);
        panel_category_ctrl.add(this.box_subcategory);
        panel_category.add((Component)panel_category_ctrl, "West");
        panel_category.add((Component)this.category_output, "Center");
        JButton btn_category = new JButton("Category");
        btn_category.setMargin(new Insets(0, 0, 0, 0));
        this.box_category.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] sub = Generator.CATEGORY.values()[((Window)Window.this).box_category.getSelectedIndex()].subcategories;
                Window.this.box_subcategory.removeAllItems();
                if (sub != null) {
                    for (String s : sub) {
                        Window.this.box_subcategory.addItem(s);
                    }
                }
                Window.this.box_subcategory.setEnabled(sub != null);
            }
        });
        this.box_category.setSelectedIndex(0);
        btn_category.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.gen_category();
            }
        });
        panel_category.add((Component)btn_category, "East");
        JPanel panel_north = new JPanel(new GridLayout(4, 1));
        panel_north.add(panel_seed);
        panel_north.add(panel_number);
        panel_north.add(panel_query);
        panel_north.add(panel_category);
        this.filler.setLineWrap(true);
        this.filler.setWrapStyleWord(true);
        this.filler.setMargin(new Insets(0, 20, 0, 20));
        this.shuffler.setLineWrap(true);
        this.shuffler.setWrapStyleWord(true);
        this.filler.setMargin(new Insets(0, 20, 0, 20));
        JPanel panel_center = new JPanel(new BorderLayout());
        JLabel lbl_shuffler = new JLabel("Shuffle list of options", 0);
        JButton btn_shuffler = new JButton("Shuffle");
        btn_shuffler.setMargin(new Insets(0, 0, 0, 0));
        btn_shuffler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.gen_shuffle();
            }
        });
        JLabel lbl_filler = new JLabel("Filler text", 0);
        JButton btn_filler = new JButton("Fill");
        this.box_filler = new JComboBox<String>(new String[]{"Words", "Sentences", "Paragraphs"});
        this.nb_filler = new JTextField("8");
        btn_filler.setMargin(new Insets(0, 0, 0, 0));
        btn_filler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.gen_filler();
            }
        });
        for (int i = 0; i < LanguageData.letters.length; ++i) {
            this.input_frequency[i] = new JTextField();
            JLabel lbl = new JLabel(LanguageData.letters[i]);
            this.input_frequency[i].setMargin(new Insets(0, 0, 0, 0));
            this.panel_frequency.add(lbl);
            this.panel_frequency.add(this.input_frequency[i]);
        }
        this.box_filler_language.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < LanguageData.letters.length; ++i) {
                    Window.this.input_frequency[i].setText(Ixe.rax(LanguageData.letter_frequency[Window.this.box_filler_language.getSelectedIndex()][i]));
                }
            }
        });
        this.box_filler_language.setSelectedIndex(1);
        JPanel pnl_center_north = new JPanel(new GridLayout(1, 2));
        pnl_center_north.add(lbl_shuffler);
        pnl_center_north.add(lbl_filler);
        JPanel pnl_center_south = new JPanel(new GridLayout(1, 2));
        pnl_center_south.add(btn_shuffler);
        JPanel panel_filler_ctl = new JPanel(new GridLayout(1, 4));
        panel_filler_ctl.add(this.box_filler_language);
        panel_filler_ctl.add(this.nb_filler);
        panel_filler_ctl.add(this.box_filler);
        panel_filler_ctl.add(btn_filler);
        pnl_center_south.add(panel_filler_ctl);
        JScrollPane scroller_shuffler = new JScrollPane(this.shuffler);
        scroller_shuffler.setVerticalScrollBarPolicy(22);
        scroller_shuffler.setHorizontalScrollBarPolicy(31);
        JPanel panel_filler = new JPanel(new BorderLayout());
        JPanel pnl_filler_frequency = new JPanel(new BorderLayout());
        pnl_filler_frequency.add((Component)this.panel_frequency, "North");
        panel_filler.add((Component)pnl_filler_frequency, "West");
        panel_filler.add((Component)this.filler, "Center");
        JScrollPane scroller_filler = new JScrollPane(panel_filler);
        scroller_filler.setVerticalScrollBarPolicy(22);
        scroller_filler.setHorizontalScrollBarPolicy(31);
        JPanel pnl_center_center = new JPanel(new GridLayout(1, 2));
        pnl_center_center.add(scroller_shuffler);
        pnl_center_center.add(scroller_filler);
        panel_center.add((Component)pnl_center_north, "North");
        panel_center.add((Component)pnl_center_center, "Center");
        panel_center.add((Component)pnl_center_south, "South");
        this.add((Component)panel_north, "North");
        this.add((Component)panel_center, "Center");
        this.fullscreen();
        this.setVisible(true);
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
    }

    public void gen_number() {
        int radix = this.number_radix.getText().isEmpty() ? 16 : (int)IxeMath.parse(this.number_radix.getText());
        this.gen_number(radix);
    }

    public void gen_number(int radix) {
        this.seed(false);
        int digits = this.number_digits.getText().isEmpty() ? 8 : (int)IxeMath.parse(this.number_digits.getText());
        boolean sign = this.number_sign.isSelected();
        this.number_output.setText(Generator.generate(sign, digits, radix));
    }

    public void gen_category() {
        this.seed(false);
        String text = "";
        text = this.box_subcategory.isEnabled() && this.box_subcategory.getSelectedIndex() != -1 ? Generator.generate(Generator.CATEGORY.values()[this.box_category.getSelectedIndex()], this.box_subcategory.getSelectedIndex()) : Generator.generate(Generator.CATEGORY.values()[this.box_category.getSelectedIndex()]);
        this.category_output.setText(text);
    }

    public void gen_filler() {
        int i;
        this.seed(false);
        double weight = 0.0;
        for (i = 0; i < LanguageData.letters.length; ++i) {
            this.frequency[i] = IxeMath.parse(this.input_frequency[i].getText());
            weight += this.frequency[i];
        }
        for (i = 0; i < LanguageData.letters.length; ++i) {
            int n = i;
            this.frequency[n] = this.frequency[n] / weight;
            this.input_frequency[i].setText(Ixe.rax(this.frequency[i]));
            if (i == 0) continue;
            int n2 = i;
            this.frequency[n2] = this.frequency[n2] + this.frequency[i - 1];
        }
        String text = "";
        int nb = (int)IxeMath.parse(this.nb_filler.getText());
        switch (this.box_filler.getSelectedIndex()) {
            case 0: {
                text = Generator.generate_filler_words(nb, this.frequency);
                break;
            }
            case 1: {
                text = Generator.generate_filler_sentences(nb, this.frequency);
                break;
            }
            case 2: {
                text = Generator.generate_filler_paragraphs(nb, this.frequency);
            }
        }
        this.filler.setText(text);
        this.filler.revalidate();
        this.filler.repaint();
    }

    public void gen_query() {
        this.seed(false);
        this.query_output.setText(Generator.generate(this.query_input.getText()));
    }

    public void gen_shuffle() {
        this.seed(false);
        String text = this.shuffler.getText();
        if (text.isEmpty()) {
            text = "Option A\nOption B\nOption C";
        }
        this.shuffler.setText(Generator.shuffle(text));
        this.filler.revalidate();
        this.filler.repaint();
    }

    private void seed(boolean select) {
        if (select) {
            this.seed_input.setEnabled(this.seed_box.isSelected());
        } else {
            if (this.seed_count == 0) {
                long seed = System.currentTimeMillis();
                if (this.seed_box.isSelected() && !this.seed_input.getText().isEmpty()) {
                    seed = (long)IxeMath.parse(this.seed_input.getText());
                }
                this.seed_generator.setSeed(seed);
            }
            if (this.seed_box.isSelected()) {
                ++this.seed_count;
            }
        }
        if (this.seed_count != 0) {
            Generator.seed(this.seed_generator.nextLong());
        }
        this.lbl_seed_count.setText(this.seed_box.isSelected() ? Ixe.rax(this.seed_count) : "");
    }

    public void random_seed() {
        this.seed_input.setText(Generator.generate(false, 16, 16));
        this.seed_count = 0;
        this.seed(true);
    }

    public void reset_seed() {
        this.seed_count = 0;
        this.seed(true);
    }
}

