/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_layout.Frame;
import pkg_layout.Menubar;
import pkg_layout.TabCalendar;
import pkg_layout.TabDirect;
import pkg_layout.TabMeasure;

public class Window
extends Frame {
    private TabCalendar tab_cal = new TabCalendar();
    private TabMeasure tab_measure = new TabMeasure();
    private TabDirect tab_direct = new TabDirect();
    private boolean start = true;
    private JTabbedPane pane = new JTabbedPane();

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.setJMenuBar(new Menubar(this));
        this.pane.addTab("Direct", this.tab_direct);
        this.pane.addTab("Measure", this.tab_measure);
        this.pane.addTab("Calendar", this.tab_cal);
        this.add((Component)this.pane, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Window.this.tab_direct.resize();
                Window.this.tab_measure.resize();
                Window.this.tab_cal.resize();
            }
        });
        this.pane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                switch (Window.this.pane.getSelectedIndex()) {
                    case 0: {
                        Window.this.tab_direct.request_focus();
                        break;
                    }
                    case 1: {
                        Window.this.tab_measure.request_focus();
                    }
                }
            }
        });
        this.fullscreen();
        this.setVisible(true);
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        if (this.start) {
            this.tab_direct.request_focus();
            this.start = false;
        }
    }
}

