/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.math.MathContext;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pkg_graphic.ThinButton;
import pkg_ixe.Ixe;
import pkg_ixe.IxeNumber;
import pkg_logic.Quantity;

public class TabMeasure
extends JPanel {
    private static BigDecimal zero = new BigDecimal("0");
    private static BigDecimal one = new BigDecimal("1");
    private static BigDecimal two = new BigDecimal("2");
    private static BigDecimal minus_one = new BigDecimal("-1");
    private static MathContext bdc = MathContext.DECIMAL128;
    private boolean input_override = false;
    private JTextArea area_input = new JTextArea();
    private JTextArea area_output = new JTextArea();
    private JTextArea line_nb_input = new JTextArea();
    private JTextArea line_nb_output = new JTextArea();
    private int base_in = 16;
    private int base_out = 16;
    private int scale_in = 0;
    private int scale_out = 0;
    private JTextField input_base = new JTextField();
    private JTextField output_base = new JTextField();
    private JTextField input_scale = new JTextField();
    private JTextField output_scale = new JTextField();
    private String[] units = new String[]{"Time", "Length", "Mass", "Charge", "Temperature", "Amount", "Angle"};
    private JComboBox box_measure = new JComboBox<String>(new String[]{"Time", "Length", "Mass", "Charge", "Temperature", "Amount", "Angle", "Frequency", "Force", "Pressure", "Work", "Power", "Electric Charge", "Electric Potential Difference", "Capacitance", "Electrical Resistance", "Electrical Conductance", "Magnetic Flux", "Magnetic Flux Density", "Inductance", "Absorbed Dose", "Catalytic Activity", "Area", "Volume", "Speed", "Acceleration", "Wavenumber", "Density", "Surface Density", "Specific Volume", "Current Density", "Magnetic Field Strength", "Concentration", "Mass Concentration", "Dynamic Viscosity", "Moment Of Force", "Surface Tension", "Heat Flux Density", "Heat Capacity", "Specific Heat Capacity", "Specific Energy", "Thermal Conductivity", "Energy Density", "Electric Field Strength", "Electric Charge Density", "Surface Charge Density", "Permittivity", "Permeability", "Molar Energy", "Molar Heat Capacity", "Exposure", "Absorbed Dose Rate", "Catalytic Activity Concentration"});
    private String[][] select_unit_names = new String[][]{{"Hexadecimal", "Second", "Minute", "Hour", "Day", "7 days", "Year"}, {"Default", "Meter", "Inch", "Foot", "Yard", "Mile", "Nautical Mile"}, {"Default", "Kilogram", "Gram", "Pound", "Tonne", "Solar Mass"}, {"Default", "Ampere"}, {"Default", "Kelvin"}, {"Default", "Mole"}, {"Normal", "Radian", "Degree"}};
    private JComboBox[] units_input_select = new JComboBox[this.select_unit_names.length];
    private JComboBox[] units_output_select = new JComboBox[this.select_unit_names.length];
    private JTextField[] units_input = new JTextField[this.select_unit_names.length];
    private JTextField[] units_output = new JTextField[this.select_unit_names.length];
    private BigDecimal[][] unit_vals = this.gen_unit_vals();
    private JLabel[][] north_row_labels = new JLabel[2][this.units_input.length];

    public TabMeasure() {
        this.setLayout(new BorderLayout());
        this.line_nb_input.setEnabled(false);
        this.line_nb_input.setDisabledTextColor(Color.GRAY);
        this.line_nb_input.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.line_nb_output.setEnabled(false);
        this.line_nb_output.setDisabledTextColor(Color.GRAY);
        this.line_nb_output.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.area_output.setEditable(false);
        DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TabMeasure.this.input();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TabMeasure.this.input();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TabMeasure.this.input();
            }
        };
        this.area_input.getDocument().addDocumentListener(listener);
        this.input_base.getDocument().addDocumentListener(listener);
        this.output_base.getDocument().addDocumentListener(listener);
        this.input_scale.getDocument().addDocumentListener(listener);
        this.output_scale.getDocument().addDocumentListener(listener);
        JPanel pnl_north = new JPanel(new BorderLayout());
        JPanel pnl_center = new JPanel(new GridLayout(1, 2));
        JPanel pnl_north2 = new JPanel(new GridLayout(1, 5));
        JPanel pnl_north3 = new JPanel(new GridLayout(7, 4));
        JPanel pnl_swap = new JPanel(new GridLayout(1, 3));
        ThinButton btn_swap = new ThinButton("\u2b64");
        pnl_swap.add(new JLabel());
        pnl_swap.add(btn_swap);
        pnl_swap.add(new JLabel());
        pnl_north2.add(this.north_subpanel(new JLabel("Base"), this.input_base));
        pnl_north2.add(this.north_subpanel(new JLabel("Scale"), this.input_scale));
        pnl_north2.add(pnl_swap);
        pnl_north2.add(this.north_subpanel(new JLabel("Base"), this.output_base));
        pnl_north2.add(this.north_subpanel(new JLabel("Scale"), this.output_scale));
        for (int i = 0; i < this.units_input.length; ++i) {
            this.units_input[i] = new JTextField();
            this.units_input[i].getDocument().addDocumentListener(listener);
            this.units_input_select[i] = new JComboBox<String>(this.select_unit_names[i]);
            this.units_input_select[i].setPreferredSize(new Dimension(25, 20));
            final int x = i;
            this.units_input_select[i].addItemListener(new ItemListener(){
                final /* synthetic */ TabMeasure this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.this$0.input_select(x);
                    this.this$0.input();
                }
            });
            this.north_row_labels[0][i] = new JLabel(this.units[i]);
            this.units_output[i] = new JTextField();
            this.units_output[i].getDocument().addDocumentListener(listener);
            this.units_output_select[i] = new JComboBox<String>(this.select_unit_names[i]);
            this.units_output_select[i].addItemListener(new ItemListener(){
                final /* synthetic */ TabMeasure this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.this$0.output_select(x);
                    this.this$0.input();
                }
            });
            this.north_row_labels[1][i] = new JLabel(this.units[i]);
            pnl_north3.add(this.north_subpanel(this.north_row_labels[0][i], this.units_input_select[i]));
            pnl_north3.add(this.units_input[i]);
            pnl_north3.add(this.north_subpanel(this.north_row_labels[1][i], this.units_output_select[i]));
            pnl_north3.add(this.units_output[i]);
        }
        this.box_measure.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TabMeasure.this.box_select();
            }
        });
        this.box_select();
        JPanel panel = new JPanel();
        panel.add(new JLabel("Measurement"));
        panel.add(this.box_measure);
        JPanel pnl_subnorth = new JPanel(new BorderLayout());
        pnl_subnorth.add((Component)pnl_north2, "North");
        pnl_subnorth.add((Component)pnl_north3, "Center");
        pnl_north.add((Component)panel, "North");
        pnl_north.add((Component)pnl_subnorth, "Center");
        JPanel area_panel1 = new JPanel(new BorderLayout());
        area_panel1.add((Component)this.area_input, "Center");
        area_panel1.add((Component)this.line_nb_input, "West");
        JPanel area_panel2 = new JPanel(new BorderLayout());
        area_panel2.add((Component)this.area_output, "Center");
        area_panel2.add((Component)this.line_nb_output, "West");
        JScrollPane pane1 = new JScrollPane(area_panel1);
        JScrollPane pane2 = new JScrollPane(area_panel2);
        pnl_center.add(pane1);
        pnl_center.add(pane2);
        btn_swap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabMeasure.this.input_override = true;
                String content = TabMeasure.this.area_output.getText();
                String temp_scale = TabMeasure.this.input_scale.getText();
                TabMeasure.this.input_scale.setText(TabMeasure.this.output_scale.getText());
                TabMeasure.this.output_scale.setText(temp_scale);
                String temp_base = TabMeasure.this.input_base.getText();
                TabMeasure.this.input_base.setText(TabMeasure.this.output_base.getText());
                TabMeasure.this.output_base.setText(temp_base);
                for (int i = 0; i < TabMeasure.this.units_input.length; ++i) {
                    int temp_select = TabMeasure.this.units_input_select[i].getSelectedIndex();
                    TabMeasure.this.units_input_select[i].setSelectedIndex(TabMeasure.this.units_output_select[i].getSelectedIndex());
                    TabMeasure.this.units_output_select[i].setSelectedIndex(temp_select);
                    String temp = TabMeasure.this.units_input[i].getText();
                    TabMeasure.this.units_input[i].setText(TabMeasure.this.units_output[i].getText());
                    TabMeasure.this.units_output[i].setText(temp);
                }
                TabMeasure.this.input_override = false;
                TabMeasure.this.area_input.setText(content);
            }
        });
        this.add((Component)pnl_north, "North");
        this.add((Component)pnl_center, "Center");
    }

    private void box_select() {
        int x = this.box_measure.getSelectedIndex();
        for (int i = 0; i < this.units_output.length; ++i) {
            this.north_row_labels[0][i].setForeground(Quantity.use(x, i) ? Color.BLACK : Color.GRAY);
            this.north_row_labels[1][i].setForeground(Quantity.use(x, i) ? Color.BLACK : Color.GRAY);
        }
        this.input();
    }

    public void resize() {
    }

    private BigDecimal[][] gen_unit_vals() {
        BigDecimal u1 = this._gen("131072", "86400");
        BigDecimal u2 = u1.divide(new BigDecimal("299792458"), bdc);
        BigDecimal u3 = u1.divide(u2.multiply(u2).multiply(new BigDecimal("6.62607015E-34")), bdc);
        BigDecimal u4 = one.divide(new BigDecimal("1.602176634E-19"), bdc);
        BigDecimal u5 = new BigDecimal("1.380649E-23").multiply(u2).multiply(u2).multiply(u3).divide(u1.multiply(u1), bdc);
        BigDecimal u6 = new BigDecimal("6.02214076E23");
        BigDecimal v1 = one.divide(u1, bdc);
        BigDecimal v2 = one.divide(u2, bdc);
        BigDecimal v3 = one.divide(u3, bdc);
        BigDecimal v4 = one.divide(u4, bdc);
        BigDecimal v5 = one.divide(u5, bdc);
        BigDecimal v6 = one.divide(u6, bdc);
        BigDecimal[][] unit_vals = new BigDecimal[][]{{one, v1, v1.multiply(this._gen("60")), v1.multiply(this._gen("3600")), v1.multiply(this._gen("86400")), v1.multiply(this._gen("604800")), v1.multiply(this._gen("31556926.08"))}, {one, v2, v2.multiply(this._gen("0.0254")), v2.multiply(this._gen("0.3048")), v2.multiply(this._gen("0.9144")), v2.multiply(this._gen("1609.344")), v2.multiply(this._gen("1852"))}, {one, v3, v3.multiply(this._gen("0.001")), v3.multiply(this._gen("0.45")), v3.multiply(this._gen("1000")), v3.multiply(this._gen("1.988416E30"))}, {one, v4}, {one, v5}, {one, v6}, {one, new BigDecimal(Math.PI).multiply(two), new BigDecimal(360)}};
        return unit_vals;
    }

    private BigDecimal _gen(String denom) {
        return this._gen("1", denom);
    }

    private BigDecimal _gen(String nom, String denom) {
        return new BigDecimal(nom).divide(new BigDecimal(denom), bdc);
    }

    private void input_select(int x) {
        if (x < 0 || x >= this.units_input.length || this.units_input_select[x].getSelectedIndex() < 0 || this.units_input_select[x].getSelectedIndex() >= this.unit_vals[x].length || this.input_override) {
            return;
        }
        this.units_input[x].setText(IxeNumber.str(this.unit_vals[x][this.units_input_select[x].getSelectedIndex()].doubleValue(), 10));
    }

    private void output_select(int x) {
        if (x < 0 || x >= this.units_output.length || this.units_output_select[x].getSelectedIndex() < 0 || this.units_output_select[x].getSelectedIndex() >= this.unit_vals[x].length || this.input_override) {
            return;
        }
        this.units_output[x].setText(IxeNumber.str(this.unit_vals[x][this.units_output_select[x].getSelectedIndex()].doubleValue(), 10));
    }

    private JPanel north_subpanel(JLabel lbl, JComponent comp) {
        JPanel panel = new JPanel(new BorderLayout());
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        panel.add((Component)lbl, "West");
        panel.add((Component)comp, "Center");
        return panel;
    }

    private void input() {
        int i;
        if (this.input_override) {
            return;
        }
        String[] split = this.area_input.getText().split("\n");
        String out = "";
        try {
            this.base_in = Ixe.clamp(Integer.parseInt(this.input_base.getText(), 16), 2, 36);
        }
        catch (Exception e) {
            this.base_in = 16;
        }
        try {
            this.base_out = Ixe.clamp(Integer.parseInt(this.output_base.getText(), 16), 2, 36);
        }
        catch (Exception e) {
            this.base_out = 16;
        }
        try {
            this.scale_in = Integer.parseInt(this.input_scale.getText(), 16);
            if (this.scale_in > IxeNumber.MAX_SCALE) {
                this.scale_in = IxeNumber.MAX_SCALE;
            }
        }
        catch (Exception e) {
            this.scale_in = 0;
        }
        try {
            this.scale_out = Integer.parseInt(this.output_scale.getText(), 16);
            if (this.scale_out > IxeNumber.MAX_SCALE) {
                this.scale_out = IxeNumber.MAX_SCALE;
            }
        }
        catch (Exception e) {
            this.scale_out = 0;
        }
        BigDecimal factor_in = new BigDecimal(this.base_in).pow(this.scale_in);
        BigDecimal factor_out = new BigDecimal(this.base_out).pow(this.scale_out);
        BigDecimal scale_factor = factor_in.divide(factor_out, bdc);
        BigDecimal[] convert = new BigDecimal[7];
        for (i = 0; i < convert.length; ++i) {
            BigDecimal out_conv;
            BigDecimal in_conv;
            if (this.units_input[i].getText().isEmpty()) {
                in_conv = one;
            } else {
                try {
                    in_conv = this.parse(this.units_input[i].getText(), 16)[0];
                }
                catch (Exception e) {
                    in_conv = zero;
                }
            }
            if (this.units_output[i].getText().isEmpty()) {
                out_conv = one;
            } else {
                try {
                    out_conv = this.parse(this.units_output[i].getText(), 16)[0];
                }
                catch (Exception e) {
                    out_conv = zero;
                }
            }
            convert[i] = zero;
            if (in_conv.compareTo(zero) == 0) continue;
            convert[i] = out_conv.divide(in_conv, bdc);
        }
        for (i = 0; i < split.length; ++i) {
            String s = "";
            boolean line = false;
            block14: for (int j = 0; j < split[i].length(); ++j) {
                char c = split[i].charAt(j);
                if (this.digit(c, this.base_in) == -1 && c != '.' && c != '-') continue;
                for (int k = j; k < split[i].length(); ++k) {
                    String substring;
                    BigDecimal[] d;
                    int length = split[i].length() - k;
                    char c2 = split[i].charAt(j + length - 1);
                    if (this.digit(c2, this.base_in) == -1 || (d = this.parse(substring = split[i].substring(j, j + length), this.base_in)) == null || d.length != 1) continue;
                    d[0] = Quantity.convert(d[0], this.box_measure.getSelectedIndex(), convert).multiply(scale_factor);
                    s = IxeNumber.str(d[0].doubleValue(), 20, this.base_out);
                    if (line) {
                        out = out + ", ";
                    }
                    line = true;
                    out = out + s;
                    j += length - 1;
                    continue block14;
                }
            }
            out = out + '\n';
        }
        this.area_output.setText(out);
        this.line_nb();
    }

    private BigDecimal[] parse(String exp, int base) {
        if (exp == null || exp.length() == 0) {
            return null;
        }
        boolean sign = false;
        boolean fract = false;
        boolean sci = false;
        BigDecimal num = zero;
        int sci_pow = 0;
        int sci_num = 0;
        int sci_index = -1;
        boolean sci_sign = false;
        BigDecimal base_bi = new BigDecimal(base);
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            int digit = this.digit(c, base);
            if (digit == -1) {
                if (c == '-' && i == 0) {
                    sign = true;
                    continue;
                }
                if (c == '-' && i == sci_index + 1) {
                    sci_sign = true;
                    continue;
                }
                if (c == '.' && !fract) {
                    fract = true;
                    continue;
                }
                if (c == '\\' && !sci) {
                    sci = true;
                    sci_index = i;
                    continue;
                }
                return null;
            }
            if (sci) {
                sci_num *= base;
                sci_num += digit;
                continue;
            }
            num = fract ? num.add(new BigDecimal(digit).divide(base_bi.pow(++sci_pow), bdc)) : num.multiply(base_bi).add(new BigDecimal(digit));
        }
        if (sign) {
            num = num.multiply(minus_one);
        }
        num = sci_sign ? num.divide(new BigDecimal(base).pow(sci_num), bdc) : num.multiply(new BigDecimal(base).pow(sci_num));
        return new BigDecimal[]{num};
    }

    private int digit(char c, int radix) {
        int digit = -1;
        if (c <= '9' && c >= '0') {
            digit = c - 48;
        } else if (c <= 'Z' && c >= 'A') {
            digit = 10 + c - 65;
        } else if (c <= 'z' && c >= 'a') {
            digit = 10 + c - 97;
        }
        if (digit >= radix) {
            digit = -1;
        }
        return digit;
    }

    private void line_nb() {
        String line_nb1 = "";
        for (int i = 0; i < this.area_input.getLineCount(); ++i) {
            line_nb1 = line_nb1 + Ixe.rax(i) + "\n";
        }
        this.line_nb_input.setText(line_nb1);
        String line_nb2 = "";
        for (int i = 0; i < this.area_output.getLineCount(); ++i) {
            line_nb2 = line_nb2 + Ixe.rax(i) + "\n";
        }
        this.line_nb_output.setText(line_nb2);
    }

    public void request_focus() {
        this.area_input.requestFocusInWindow();
    }
}

