/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.MathContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pkg_graphic.ThinButton;
import pkg_ixe.Ixe;
import pkg_ixe.IxeNumber;

public class TabDirect
extends JPanel {
    private static BigDecimal zero = new BigDecimal("0");
    private static BigDecimal one = new BigDecimal("1");
    private static BigDecimal two = new BigDecimal("2");
    private static BigDecimal minus_one = new BigDecimal("-1");
    private static MathContext bdc = MathContext.DECIMAL128;
    private boolean input_override = false;
    private JTextArea area_input = new JTextArea();
    private JTextArea area_output = new JTextArea();
    private JTextArea line_nb_input = new JTextArea();
    private JTextArea line_nb_output = new JTextArea();
    private int base_in = 16;
    private int base_out = 16;
    private int scale_in = 0;
    private int scale_out = 0;
    private JTextField input_base = new JTextField();
    private JTextField output_base = new JTextField();
    private JTextField input_scale = new JTextField();
    private JTextField output_scale = new JTextField();
    private JTextField convert_to = new JTextField();
    private JTextField convert_from = new JTextField();

    public TabDirect() {
        this.setLayout(new BorderLayout());
        this.convert_from.setEnabled(false);
        this.line_nb_input.setEnabled(false);
        this.line_nb_input.setDisabledTextColor(Color.GRAY);
        this.line_nb_input.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.line_nb_output.setEnabled(false);
        this.line_nb_output.setDisabledTextColor(Color.GRAY);
        this.line_nb_output.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.area_output.setEditable(false);
        DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TabDirect.this.input();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TabDirect.this.input();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TabDirect.this.input();
            }
        };
        this.area_input.getDocument().addDocumentListener(listener);
        this.input_base.getDocument().addDocumentListener(listener);
        this.output_base.getDocument().addDocumentListener(listener);
        this.input_scale.getDocument().addDocumentListener(listener);
        this.output_scale.getDocument().addDocumentListener(listener);
        JPanel pnl_north = new JPanel(new GridLayout(1, 5));
        JPanel pnl_center = new JPanel(new GridLayout(1, 2));
        pnl_north.setPreferredSize(new Dimension(0, 22));
        this.convert_to.getDocument().addDocumentListener(listener);
        JPanel pnl_swap = new JPanel(new GridLayout(1, 3));
        ThinButton btn_swap = new ThinButton("\u2b64");
        pnl_swap.add(new JLabel());
        pnl_swap.add(btn_swap);
        pnl_swap.add(new JLabel());
        pnl_north.add(this.north_subpanel(new JLabel("To"), this.convert_to));
        pnl_north.add(this.north_subpanel(new JLabel("Base"), this.input_base));
        pnl_north.add(this.north_subpanel(new JLabel("Scale"), this.input_scale));
        pnl_north.add(pnl_swap);
        pnl_north.add(this.north_subpanel(new JLabel("From"), this.convert_from));
        pnl_north.add(this.north_subpanel(new JLabel("Base"), this.output_base));
        pnl_north.add(this.north_subpanel(new JLabel("Scale"), this.output_scale));
        JPanel area_panel1 = new JPanel(new BorderLayout());
        area_panel1.add((Component)this.area_input, "Center");
        area_panel1.add((Component)this.line_nb_input, "West");
        JPanel area_panel2 = new JPanel(new BorderLayout());
        area_panel2.add((Component)this.area_output, "Center");
        area_panel2.add((Component)this.line_nb_output, "West");
        JScrollPane pane1 = new JScrollPane(area_panel1);
        JScrollPane pane2 = new JScrollPane(area_panel2);
        pnl_center.add(pane1);
        pnl_center.add(pane2);
        btn_swap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabDirect.this.input_override = true;
                String content = TabDirect.this.area_output.getText();
                String temp_scale = TabDirect.this.input_scale.getText();
                TabDirect.this.input_scale.setText(TabDirect.this.output_scale.getText());
                TabDirect.this.output_scale.setText(temp_scale);
                String temp_base = TabDirect.this.input_base.getText();
                TabDirect.this.input_base.setText(TabDirect.this.output_base.getText());
                TabDirect.this.output_base.setText(temp_base);
                String temp_convert = TabDirect.this.convert_to.getText();
                TabDirect.this.convert_to.setText(TabDirect.this.convert_from.getText());
                TabDirect.this.convert_from.setText(temp_convert);
                TabDirect.this.input_override = false;
                TabDirect.this.area_input.setText(content);
            }
        });
        this.add((Component)pnl_north, "North");
        this.add((Component)pnl_center, "Center");
    }

    private JPanel north_subpanel(JLabel lbl, JComponent comp) {
        JPanel panel = new JPanel(new BorderLayout());
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        panel.add((Component)lbl, "West");
        panel.add((Component)comp, "Center");
        return panel;
    }

    private void input() {
        BigDecimal convert;
        if (this.input_override) {
            return;
        }
        String[] split = this.area_input.getText().split("\n");
        String out = "";
        try {
            this.base_in = Ixe.clamp(Integer.parseInt(this.input_base.getText(), 16), 2, 36);
        }
        catch (Exception e) {
            this.base_in = 16;
        }
        try {
            this.base_out = Ixe.clamp(Integer.parseInt(this.output_base.getText(), 16), 2, 36);
        }
        catch (Exception e) {
            this.base_out = 16;
        }
        try {
            this.scale_in = Integer.parseInt(this.input_scale.getText(), 16);
            if (this.scale_in > IxeNumber.MAX_SCALE) {
                this.scale_in = IxeNumber.MAX_SCALE;
            }
        }
        catch (Exception e) {
            this.scale_in = 0;
        }
        try {
            this.scale_out = Integer.parseInt(this.output_scale.getText(), 16);
            if (this.scale_out > IxeNumber.MAX_SCALE) {
                this.scale_out = IxeNumber.MAX_SCALE;
            }
        }
        catch (Exception e) {
            this.scale_out = 0;
        }
        BigDecimal factor_in = new BigDecimal(this.base_in).pow(this.scale_in);
        BigDecimal factor_out = new BigDecimal(this.base_out).pow(this.scale_out);
        BigDecimal scale_factor = factor_in.divide(factor_out, bdc);
        try {
            convert = this.parse(this.convert_to.getText(), 16)[0];
        }
        catch (Exception e) {
            convert = one;
        }
        this.convert_from.setText(IxeNumber.str(one.divide(convert, bdc).doubleValue(), 8, 16));
        for (int i = 0; i < split.length; ++i) {
            String s = "";
            boolean line = false;
            block11: for (int j = 0; j < split[i].length(); ++j) {
                char c = split[i].charAt(j);
                if (this.digit(c, this.base_in) == -1 && c != '.' && c != '-') continue;
                for (int k = j; k < split[i].length(); ++k) {
                    String substring;
                    BigDecimal[] d;
                    int length = split[i].length() - k;
                    char c2 = split[i].charAt(j + length - 1);
                    if (this.digit(c2, this.base_in) == -1 || (d = this.parse(substring = split[i].substring(j, j + length), this.base_in)) == null || d.length != 1) continue;
                    d[0] = d[0].multiply(convert).multiply(scale_factor);
                    s = IxeNumber.str(d[0].doubleValue(), 20, this.base_out);
                    if (line) {
                        out = out + ", ";
                    }
                    line = true;
                    out = out + s;
                    j += length - 1;
                    continue block11;
                }
            }
            out = out + '\n';
        }
        this.area_output.setText(out);
        this.line_nb();
    }

    public void resize() {
    }

    private BigDecimal[] parse(String exp, int base) {
        if (exp == null || exp.length() == 0) {
            return null;
        }
        boolean sign = false;
        boolean fract = false;
        boolean sci = false;
        BigDecimal num = zero;
        int sci_pow = 0;
        int sci_num = 0;
        int sci_index = -1;
        boolean sci_sign = false;
        BigDecimal base_bi = new BigDecimal(base);
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            int digit = this.digit(c, base);
            if (digit == -1) {
                if (c == '-' && i == 0) {
                    sign = true;
                    continue;
                }
                if (c == '-' && i == sci_index + 1) {
                    sci_sign = true;
                    continue;
                }
                if (c == '.' && !fract) {
                    fract = true;
                    continue;
                }
                if (c == '\\' && !sci) {
                    sci = true;
                    sci_index = i;
                    continue;
                }
                return null;
            }
            if (sci) {
                sci_num *= base;
                sci_num += digit;
                continue;
            }
            num = fract ? num.add(new BigDecimal(digit).divide(base_bi.pow(++sci_pow), bdc)) : num.multiply(base_bi).add(new BigDecimal(digit));
        }
        if (sign) {
            num = num.multiply(minus_one);
        }
        num = sci_sign ? num.divide(new BigDecimal(base).pow(sci_num), bdc) : num.multiply(new BigDecimal(base).pow(sci_num));
        return new BigDecimal[]{num};
    }

    private int digit(char c, int radix) {
        int digit = -1;
        if (c <= '9' && c >= '0') {
            digit = c - 48;
        } else if (c <= 'Z' && c >= 'A') {
            digit = 10 + c - 65;
        } else if (c <= 'z' && c >= 'a') {
            digit = 10 + c - 97;
        }
        if (digit >= radix) {
            digit = -1;
        }
        return digit;
    }

    private void line_nb() {
        String line_nb1 = "";
        for (int i = 0; i < this.area_input.getLineCount(); ++i) {
            line_nb1 = line_nb1 + Ixe.rax(i) + "\n";
        }
        this.line_nb_input.setText(line_nb1);
        String line_nb2 = "";
        for (int i = 0; i < this.area_output.getLineCount(); ++i) {
            line_nb2 = line_nb2 + Ixe.rax(i) + "\n";
        }
        this.line_nb_output.setText(line_nb2);
    }

    public void request_focus() {
        this.area_input.requestFocusInWindow();
    }
}

