/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pkg_graphic.ThinButton;
import pkg_ixe.Ixe;
import pkg_ixe.IxeDate;
import pkg_ixe.IxeTime;

public class TabCalendar
extends JPanel {
    JTextField[] input_date = new JTextField[4];
    JTextField[] input_time = new JTextField[4];
    JTextField[] output_date = new JTextField[4];
    JTextField[] output_time = new JTextField[4];
    String[] date_types = new String[]{"RELATIVE", "ABSOLUTE", "GREGORIAN"};
    JComboBox date_select_in = new JComboBox<String>(this.date_types);
    JComboBox date_select_out = new JComboBox<String>(this.date_types);
    String[] time_types = new String[]{"HEXADECIMAL", "DOZENAL"};
    JComboBox time_select_in = new JComboBox<String>(this.time_types);
    JComboBox time_select_out = new JComboBox<String>(this.time_types);
    int[] previous_select = new int[4];
    DocumentListener listener_date = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            TabCalendar.this.input(false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TabCalendar.this.input(false);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TabCalendar.this.input(false);
        }
    };
    DocumentListener listener_time = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            TabCalendar.this.input(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TabCalendar.this.input(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TabCalendar.this.input(true);
        }
    };

    public TabCalendar() {
        super(new BorderLayout());
        for (int i = 0; i < this.input_date.length; ++i) {
            this.input_date[i] = new JTextField();
            this.input_time[i] = new JTextField();
            this.output_date[i] = new JTextField();
            this.output_time[i] = new JTextField();
            this.output_date[i].setEnabled(false);
            this.output_time[i].setEnabled(false);
            this.output_date[i].setDisabledTextColor(Color.BLACK);
            this.output_time[i].setDisabledTextColor(Color.BLACK);
            this.input_date[i].getDocument().addDocumentListener(this.listener_date);
            this.input_time[i].getDocument().addDocumentListener(this.listener_time);
        }
        this.date_select_in.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                long[] data = new long[4];
                TabCalendar.this.input_date(TabCalendar.this.get_input_date(TabCalendar.this.previous_select[0]), data, TabCalendar.this.date_select_in.getSelectedIndex());
                TabCalendar.this.enable_logic(false, TabCalendar.this.date_select_in, TabCalendar.this.time_select_in, TabCalendar.this.input_date, TabCalendar.this.input_time);
                for (int i = 0; i < TabCalendar.this.input_date.length; ++i) {
                    TabCalendar.this.input_date[i].setText(Ixe.rax(data[i]));
                }
                TabCalendar.this.input(false);
                TabCalendar.this.previous_select[0] = TabCalendar.this.date_select_in.getSelectedIndex();
            }
        });
        this.time_select_in.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                double[] data = new double[4];
                TabCalendar.this.input_time(TabCalendar.this.get_input_time(TabCalendar.this.previous_select[2]), data, TabCalendar.this.time_select_in.getSelectedIndex());
                TabCalendar.this.enable_logic(true, TabCalendar.this.date_select_in, TabCalendar.this.time_select_in, TabCalendar.this.input_date, TabCalendar.this.input_time);
                for (int i = 0; i < TabCalendar.this.input_time.length; ++i) {
                    TabCalendar.this.input_time[i].setText(Ixe.rax(data[i]));
                }
                TabCalendar.this.input(true);
                TabCalendar.this.previous_select[2] = TabCalendar.this.time_select_in.getSelectedIndex();
            }
        });
        this.date_select_out.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TabCalendar.this.enable_logic(false, TabCalendar.this.date_select_out, TabCalendar.this.time_select_out, TabCalendar.this.output_date, TabCalendar.this.output_time);
                TabCalendar.this.input(false);
            }
        });
        this.time_select_out.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TabCalendar.this.enable_logic(true, TabCalendar.this.date_select_out, TabCalendar.this.time_select_out, TabCalendar.this.output_date, TabCalendar.this.output_time);
                TabCalendar.this.input(true);
            }
        });
        this.enable_logic(false, this.date_select_in, this.time_select_in, this.input_date, this.input_time);
        this.enable_logic(true, this.date_select_in, this.time_select_in, this.input_date, this.input_time);
        this.enable_logic(false, this.date_select_out, this.time_select_out, this.output_date, this.output_time);
        this.enable_logic(true, this.date_select_out, this.time_select_out, this.output_date, this.output_time);
        JPanel grid = new JPanel(new GridLayout(2, 1));
        grid.add(this.make_bag(this.input_date, this.output_date, this.date_select_in, this.date_select_out, false));
        grid.add(this.make_bag(this.input_time, this.output_time, this.time_select_in, this.time_select_out, true));
        this.add((Component)grid, "North");
    }

    public void resize() {
    }

    private JPanel make_bag(JTextField[] in, JTextField[] out, JComboBox box1, JComboBox box2, final boolean type) {
        int i;
        JPanel bag = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        bag.setBorder(BorderFactory.createTitledBorder(null, type ? "Time Converter" : "Date Converter", 2, 0));
        ThinButton btn_swap = new ThinButton("\u2b64");
        ThinButton btn_now = new ThinButton("\u29d6");
        btn_swap.addActionListener(new ActionListener(){
            final /* synthetic */ TabCalendar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.change(type);
            }
        });
        btn_now.addActionListener(new ActionListener(){
            final /* synthetic */ TabCalendar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.now(type);
            }
        });
        int grid_x = 0;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = grid_x++;
        c.gridy = 0;
        bag.add((Component)btn_now, c);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = grid_x++;
        c.gridy = 0;
        bag.add((Component)box1, c);
        for (i = 0; i < in.length; ++i) {
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = grid_x++;
            c.gridy = 0;
            bag.add((Component)in[i], c);
        }
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = grid_x++;
        c.gridy = 0;
        bag.add((Component)btn_swap, c);
        for (i = 0; i < out.length; ++i) {
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = grid_x++;
            c.gridy = 0;
            bag.add((Component)out[i], c);
        }
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = grid_x++;
        c.gridy = 0;
        bag.add((Component)box2, c);
        return bag;
    }

    private void enable_logic(boolean type, JComboBox date_select, JComboBox time_select, JTextField[] date, JTextField[] time) {
        if (!type) {
            switch (date_select.getSelectedIndex()) {
                case 0: {
                    date[0].setVisible(false);
                    break;
                }
                case 1: {
                    date[0].setVisible(true);
                    break;
                }
                case 2: {
                    date[0].setVisible(false);
                }
            }
        } else {
            switch (time_select.getSelectedIndex()) {
                case 0: {
                    time[0].setVisible(true);
                    break;
                }
                case 1: {
                    time[0].setVisible(false);
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void change(boolean type) {
        if (!type) {
            int i;
            String[] out = new String[this.output_date.length];
            for (i = 0; i < out.length; ++i) {
                out[i] = this.output_date[i].getText();
            }
            int temp = this.date_select_in.getSelectedIndex();
            this.date_select_in.setSelectedIndex(this.date_select_out.getSelectedIndex());
            this.date_select_out.setSelectedIndex(temp);
            for (i = 0; i < out.length; ++i) {
                this.input_date[i].setText(out[i]);
            }
        } else {
            int i;
            String[] out = new String[this.output_time.length];
            for (i = 0; i < out.length; ++i) {
                out[i] = this.output_time[i].getText();
            }
            int temp = this.time_select_in.getSelectedIndex();
            this.time_select_in.setSelectedIndex(this.time_select_out.getSelectedIndex());
            this.time_select_out.setSelectedIndex(temp);
            for (i = 0; i < out.length; ++i) {
                this.input_time[i].setText(out[i]);
            }
        }
    }

    private void now(boolean type) {
        LocalDateTime now = LocalDateTime.now();
        if (!type) {
            long[] data = new long[4];
            this.input_date(IxeDate.first_day.until(now, ChronoUnit.DAYS), data, this.date_select_in.getSelectedIndex());
            for (int i = 0; i < this.input_date.length; ++i) {
                this.input_date[i].setText(Ixe.rax(data[i]));
            }
        } else {
            double[] data = new double[4];
            double t = ((double)now.getHour() * 3600.0 + (double)now.getMinute() * 60.0 + (double)now.getSecond() + (double)now.getNano() / 1.0E9) * 1.517037037;
            this.input_time(t, data, this.time_select_in.getSelectedIndex());
            for (int i = 0; i < this.input_time.length; ++i) {
                this.input_time[i].setText(Ixe.rax(data[i]));
            }
        }
    }

    private void input(boolean type) {
        if (!type) {
            long[] data = new long[4];
            this.input_date(this.get_input_date(this.date_select_in.getSelectedIndex()), data, this.date_select_out.getSelectedIndex());
            for (int i = 0; i < this.output_date.length; ++i) {
                this.output_date[i].setText(Ixe.rax(data[i]));
            }
        } else {
            double[] data = new double[4];
            this.input_time(this.get_input_time(this.time_select_in.getSelectedIndex()), data, this.time_select_out.getSelectedIndex());
            for (int i = 0; i < this.output_time.length; ++i) {
                this.output_time[i].setText(Ixe.rax(data[i]));
            }
        }
    }

    private long get_input_date(int format) {
        long day_of_time = 0L;
        long[] date_signed = new long[4];
        switch (format) {
            case 0: {
                long year = IxeDate.day_of_time(this.read_val(this.input_date[1]), 0, 0);
                int month = this.read_val(this.input_date[2]);
                int day = this.read_val(this.input_date[3]);
                if (month < 0) {
                    long y = this.read_val(this.input_date[1]);
                    int m = 0;
                    for (int i = 0; i < -month; ++i) {
                        if (m == 0) {
                            --y;
                        }
                        m = (m + 11) % 12;
                        day_of_time -= (long)IxeDate.days_in_month(y, m);
                    }
                } else {
                    long y = this.read_val(this.input_date[1]);
                    int m = 0;
                    for (int i = 0; i < month; ++i) {
                        day_of_time += (long)IxeDate.days_in_month(y, m);
                        if ((m = (m + 1) % 12) != 0) continue;
                        ++y;
                    }
                }
                if ((day_of_time = day < 0 ? (long)(day_of_time < 0L ? -1 : 1) * (Math.abs(day_of_time) - (long)Math.abs(day)) : (long)(day_of_time < 0L ? -1 : 1) * (Math.abs(day_of_time) + (long)Math.abs(day))) < 0L) {
                    day_of_time = (long)(year < 0L ? -1 : 1) * (Math.abs(year) - Math.abs(day_of_time));
                    break;
                }
                day_of_time = (long)(year < 0L ? -1 : 1) * (Math.abs(year) + Math.abs(day_of_time));
                break;
            }
            case 1: {
                date_signed[0] = (long)this.read_val(this.input_date[0]) * 4096L;
                date_signed[1] = (long)this.read_val(this.input_date[1]) * 256L;
                date_signed[2] = (long)this.read_val(this.input_date[2]) * 16L;
                date_signed[3] = (long)this.read_val(this.input_date[3]) * 1L;
                day_of_time = this._get_input(date_signed);
                break;
            }
            case 2: {
                try {
                    LocalDate dt = LocalDate.of(this.read_val(this.input_date[1]), 1, 1).plusMonths(this.read_val(this.input_date[2])).plusDays(this.read_val(this.input_date[3]));
                    day_of_time = IxeDate.first_day.until(dt, ChronoUnit.DAYS);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return day_of_time;
    }

    private double get_input_time(int format) {
        double mod = 1.0;
        long[] time_signed = new long[4];
        for (int i = 0; i < time_signed.length; ++i) {
            time_signed[i] = this.read_val(this.input_time[i]);
        }
        switch (format) {
            case 0: {
                time_signed[0] = (long)this.read_val(this.input_time[0]) * 4096L;
                time_signed[1] = (long)this.read_val(this.input_time[1]) * 256L;
                time_signed[2] = (long)this.read_val(this.input_time[2]) * 16L;
                time_signed[3] = (long)this.read_val(this.input_time[3]) * 1L;
                break;
            }
            case 1: {
                time_signed[0] = 0L;
                time_signed[1] = (long)this.read_val(this.input_time[1]) * 3600L;
                time_signed[2] = (long)this.read_val(this.input_time[2]) * 60L;
                time_signed[3] = (long)this.read_val(this.input_time[3]) * 1L;
                mod = 1.517037037;
            }
        }
        long time = this._get_input(time_signed);
        return (double)time * mod;
    }

    private long _get_input(long[] input) {
        long time = 0L;
        for (int i = input.length - 1; i >= 0; --i) {
            long x1 = input[i];
            long x2 = i > 0 ? input[i - 1] : 0L;
            boolean sign1 = x1 < 0L;
            boolean sign2 = x2 < 0L;
            x1 = Math.abs(x1);
            x2 = Math.abs(x2);
            x2 = sign1 ? x2 - x1 : x2 + x1;
            long l = time = sign2 ? -x2 : x2;
            if (i <= 0) continue;
            input[i - 1] = time;
        }
        return time;
    }

    private int read_val(JTextField txt) {
        int val;
        try {
            val = Integer.parseInt(txt.getText(), 16);
        }
        catch (Exception e) {
            val = 0;
        }
        return val;
    }

    private void input_date(long day_of_time, long[] data, int format) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = 0L;
        }
        boolean sign = false;
        int first_col = 0;
        switch (format) {
            case 0: {
                boolean bl = sign = day_of_time < 0L;
                if (sign) {
                    day_of_time = -day_of_time;
                }
                data[1] = IxeDate.year_of_time(day_of_time);
                data[2] = IxeDate.month_of_year(day_of_time);
                data[3] = IxeDate.day_of_month(day_of_time);
                first_col = 1;
                break;
            }
            case 1: {
                boolean bl = sign = day_of_time < 0L;
                if (sign) {
                    day_of_time = -day_of_time;
                }
                long day = day_of_time;
                data[3] = day % 16L;
                data[2] = (day /= 16L) % 16L;
                data[1] = (day /= 16L) % 16L;
                data[0] = day /= 16L;
                break;
            }
            case 2: {
                LocalDate dt = IxeDate.first_day.plusDays(day_of_time);
                data[1] = dt.getYear();
                data[2] = dt.getMonthValue() - 1;
                data[3] = dt.getDayOfMonth() - 1;
                first_col = 1;
            }
        }
        if (sign) {
            for (int i = first_col; i < data.length; ++i) {
                if (data[i] == 0L) continue;
                data[i] = -data[i];
                break;
            }
        }
    }

    private void input_time(double time, double[] data, int format) {
        boolean sign;
        for (int i = 0; i < data.length; ++i) {
            data[i] = 0.0;
        }
        boolean bl = sign = time < 0.0;
        if (sign) {
            time = -time;
        }
        int first_col = 0;
        switch (format) {
            case 0: {
                long t = (long)time;
                data[0] = IxeTime.major_keep(3, t);
                data[1] = IxeTime.major(2, t);
                data[2] = IxeTime.major(1, t);
                data[3] = IxeTime.major(0, t);
                break;
            }
            case 1: {
                long t = (long)(time / 1.517037037);
                data[3] = t % 60L;
                data[2] = (t /= 60L) % 60L;
                data[1] = t /= 60L;
                first_col = 1;
            }
        }
        if (sign) {
            for (int i = first_col; i < data.length; ++i) {
                if (data[i] == 0.0) continue;
                data[i] = -data[i];
                break;
            }
        }
    }
}

