/*
 * Decompiled with CFR 0.152.
 */
package pkg_ixe;

public class IxeNumber {
    public static int MAX_SCALE = 1000;

    public static String str(double value, int nb_digits) {
        return IxeNumber.str(value, nb_digits, 16);
    }

    public static String str(double value, int nb_digits, int radix) {
        if (value == 0.0) {
            return "0";
        }
        boolean sign = value < 0.0;
        double v = sign ? -value : value;
        int primary_digit = (int)Math.floor(Math.log(v) / Math.log(radix));
        String str = sign ? "-" : "";
        String scientific_str = "";
        double pow = Math.pow(radix, primary_digit);
        if (primary_digit > (nb_digits -= str.length()) || primary_digit < -nb_digits) {
            scientific_str = "\\" + IxeNumber.scientific_value(primary_digit, radix);
            nb_digits -= scientific_str.length();
            v /= pow;
            pow = 1.0;
            primary_digit = 0;
        } else if (value < 1.0) {
            pow = 1.0;
            primary_digit = 0;
        }
        nb_digits = Math.max(nb_digits, 1);
        for (int i = 0; i < nb_digits; ++i) {
            int digit = (int)(v / pow);
            str = str + IxeNumber.digit_char(digit);
            if ((v -= (pow /= (double)radix) * (double)digit) == 0.0 && (primary_digit < 0 || i - primary_digit > 0)) break;
            if (primary_digit - i != 0) continue;
            str = str + ".";
        }
        return str + scientific_str;
    }

    private static String scientific_value(int value, int radix) {
        if (value == 0) {
            return "0";
        }
        boolean sign = value < 0;
        double v = sign ? (double)(-value) : (double)value;
        int primary_digit = (int)(Math.log(v) / Math.log(radix));
        String str = sign ? "-" : "";
        for (double pow = Math.pow(radix, primary_digit); pow >= 1.0; pow /= (double)radix) {
            int digit = (int)(v / pow);
            v -= pow * (double)digit;
            str = str + IxeNumber.digit_char(digit);
        }
        return str;
    }

    private static char digit_char(int digit) {
        return (char)(digit >= 10 ? 97 + (digit - 10) : 48 + digit);
    }
}

