/*
 * Decompiled with CFR 0.152.
 */
package pkg_ixe;

import java.time.LocalDate;

public class IxeDate {
    public static final LocalDate first_day = LocalDate.of(1992, 3, 20);
    private static final int[] days_in_month = new int[]{31, 31, 31, 32, 31, 31, 28, 31, 31, 26, 31, 31};
    private static final int[] days_at_month = new int[]{0, 31, 62, 93, 125, 156, 187, 215, 246, 277, 303, 334};

    public static int days_in_month(long year, int month) {
        return IxeDate.days_in_month(IxeDate.is_leap_year(year), month);
    }

    public static int days_in_month(boolean leap, int month) {
        int d = days_in_month[month];
        if (month == 0 && leap) {
            ++d;
        }
        return d;
    }

    public static boolean is_leap_day(long year, int month, int day) {
        if (IxeDate.is_leap_year(year)) {
            return month == 0 && day == days_in_month[0];
        }
        return false;
    }

    private static boolean is_leap_year(long year) {
        return year % 4L == 0L && year % 100L == 0L && year % 400L != 0L;
    }

    public static int day_of_week(long year, int month, int day) {
        return IxeDate.day_of_week(IxeDate.day_of_time(year, month, day));
    }

    public static int day_of_week(long day_of_time) {
        return (int)(day_of_time % 8L);
    }

    public static long day_of_time(long year, int month, int day) {
        long day_of_time = 0L;
        boolean sign = year < 0L;
        year = sign ? -year : year;
        int i = 0;
        while ((long)i < year) {
            boolean is_leap = IxeDate.is_leap_year(i);
            long year_length = 365 + (is_leap ? 1 : 0);
            day_of_time += year_length;
            ++i;
        }
        for (i = 0; i < month; ++i) {
            day_of_time += (long)IxeDate.days_in_month(year, i);
        }
        return (day_of_time + (long)day) * (long)(sign ? -1 : 1);
    }

    public static long year_of_time(long day_of_time) {
        long year = 0L;
        boolean leap = IxeDate.is_leap_year(year);
        while (!(day_of_time < 365L || leap && day_of_time == 365L)) {
            day_of_time -= leap ? 366L : 365L;
            leap = IxeDate.is_leap_year(++year);
        }
        return year;
    }

    public static int month_of_year(long day_of_time) {
        long year = 0L;
        boolean leap = IxeDate.is_leap_year(year);
        while (day_of_time >= 365L) {
            if (leap && day_of_time == 365L) {
                return 11;
            }
            day_of_time -= leap ? 366L : 365L;
            leap = IxeDate.is_leap_year(++year);
        }
        for (int i = 0; i < days_in_month.length; ++i) {
            int days = IxeDate.days_in_month(leap, i);
            if (day_of_time < (long)days) {
                return i;
            }
            day_of_time -= (long)days;
        }
        return -1;
    }

    public static int week_of_month(long day_of_time) {
        int day_of_month = IxeDate.day_of_month(day_of_time);
        long first_day = day_of_time - (long)day_of_month;
        int day_of_week = IxeDate.day_of_week(first_day);
        return (day_of_month + day_of_week) / 8;
    }

    public static int day_of_month(long day_of_time) {
        int days;
        long year = 0L;
        boolean leap = IxeDate.is_leap_year(year);
        while (day_of_time >= 365L) {
            if (leap && day_of_time == 365L) {
                return days_in_month[days_in_month.length - 1] - 1;
            }
            day_of_time -= leap ? 366L : 365L;
            leap = IxeDate.is_leap_year(++year);
        }
        for (int i = 0; i < days_in_month.length && day_of_time >= (long)(days = IxeDate.days_in_month(leap, i)); day_of_time -= (long)days, ++i) {
        }
        return (int)day_of_time;
    }

    public static long week_of_time(long day_of_time) {
        return day_of_time / 8L;
    }

    public static long month_of_time(long day_of_time) {
        return IxeDate.year_of_time(day_of_time) * 12L + (long)IxeDate.month_of_year(day_of_time);
    }
}

