/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import pkg_ixe.Ixe;
import pkg_ixe.IxeDate;
import pkg_logic.Date;

public class RelativeDate {
    public static final long MAX_DAY = 0x3FFFFFFFFFFFL;
    public static final long MAX_DATE = 9223372036854644736L;
    public Date date = new Date();
    private long year;
    private int month;
    private int day;
    private int week;
    private int day_of_week;

    public RelativeDate(long date) {
        long day_of_time = date / 131072L;
        this.year = IxeDate.year_of_time(day_of_time);
        this.month = IxeDate.month_of_year(day_of_time);
        this.day = IxeDate.day_of_month(day_of_time);
        this.eval_date();
    }

    public RelativeDate(long year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.eval_date();
    }

    private long date(long year, int month, int day) {
        long day_nb = IxeDate.day_of_time(year, month, day);
        return day_nb * 131072L;
    }

    public void dec_day() {
        if (this.day != 0) {
            --this.day;
        } else {
            if (this.month != 0) {
                --this.month;
            } else {
                this.month = 11;
                --this.year;
            }
            this.day = IxeDate.days_in_month(this.year, this.month) - 1;
        }
        this.eval_date();
    }

    public void inc_day() {
        if (this.day + 1 < IxeDate.days_in_month(this.year, this.month)) {
            ++this.day;
        } else {
            this.day = 0;
            if (this.month + 1 < 12) {
                ++this.month;
            } else {
                this.month = 0;
                ++this.year;
            }
        }
        this.eval_date();
    }

    public void dec_week() {
        if (this.day >= 8) {
            this.day -= 8;
        } else {
            if (this.month != 0) {
                --this.month;
            } else {
                this.month = 11;
                --this.year;
            }
            this.day = IxeDate.days_in_month(this.year, this.month) + (this.day - 8);
        }
        this.eval_date();
    }

    public void inc_week() {
        int days = IxeDate.days_in_month(this.year, this.month);
        if (this.day + 8 < days) {
            this.day += 8;
        } else {
            this.day = 7 - (days - this.day - 1);
            if (this.month + 1 < 12) {
                ++this.month;
            } else {
                this.month = 0;
                ++this.year;
            }
        }
        this.eval_date();
    }

    public void change_month(int diff) {
        long m = (long)this.month + this.year * 12L + (long)diff;
        this.year = (int)(m / 12L) + (m < 0L ? -1 : 0);
        this.month = (int)Ixe.mod(m, 12L);
        int month_length = IxeDate.days_in_month(this.year, this.month) - 1;
        if (this.day > month_length) {
            this.day = month_length;
        }
        this.eval_date();
    }

    public void change_year(long diff) {
        this.year += diff;
        int month_length = IxeDate.days_in_month(this.year, this.month) - 1;
        if (this.day > month_length) {
            this.day = month_length;
        }
        this.eval_date();
    }

    private void eval_date() {
        this.date.set(this.date(this.year, this.month, this.day));
    }

    public Date get_date() {
        return this.date;
    }

    public long get_year() {
        return this.year;
    }

    public int get_month() {
        return this.month;
    }

    public int get_day() {
        return this.day;
    }

    public void set_year(long year) {
        this.change_year(year - this.year);
    }

    public void set_month(int month) {
        this.change_month(month - this.month);
    }

    public String toString() {
        return this.year + "-" + this.month + "-" + this.day;
    }
}

