/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import pkg_ixe.Ixe;
import pkg_ixe.IxeDate;
import pkg_ixe.IxeTime;

public class Date {
    public static final int DAY_TERM = 4;
    public static final int WEEK_TERM = 5;
    public static final int MONTH_TERM = 6;
    public static final int YEAR_TERM = 7;
    private static final int[] unit = new int[]{16, 16, 16, 32, 8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int term_length = unit.length;
    public static final long HOUR_VAL = 4096L;
    public static final long FULL_DAY_VAL = 131072L;
    public static final long WEEK_VAL = 131072L * (long)unit[4];
    public static final long MONTH_VAL = WEEK_VAL * (long)unit[5];
    public static final long YEAR_VAL = MONTH_VAL * (long)unit[6];
    public static long current_time;
    public static long selected_time;
    public static LocalDate now;
    public long date;

    public Date() {
        this.date = current_time;
    }

    public Date(long date) {
        this.date = date;
    }

    public static int unit(int term) {
        return unit[term];
    }

    public static long first_date_of_month(long time) {
        return time - time % (131072L * (long)unit[4]);
    }

    public static long first_date_of_year(long time) {
        return time - time % (131072L * (long)unit[4] * (long)unit[5] * (long)unit[6]);
    }

    public long get(int term) {
        return this.get(term, false);
    }

    public long get(int term, boolean keep) {
        return Date.get(term, keep, this.date);
    }

    public static long get(int term, boolean keep, long date) {
        if (term < 0 || term >= term_length) {
            return 0L;
        }
        long get = date;
        for (int i = 0; i < term; ++i) {
            get /= (long)unit[i];
        }
        return keep ? get : get % (long)unit[term];
    }

    public void change(long diff) {
        this.date = Ixe.clamp(this.date + diff, 0L, 9223372036854644736L);
    }

    public void change_day(int diff) {
        this.change(131072L * (long)diff);
    }

    public static long change_day(long date, int diff) {
        return Ixe.clamp(date + 131072L * (long)diff, 0L, 9223372036854644736L);
    }

    public void change_week(int diff) {
        this.change(WEEK_VAL * (long)diff);
    }

    public static long change_week(long date, int diff) {
        return Ixe.clamp(date + WEEK_VAL * (long)diff, 0L, 9223372036854644736L);
    }

    public void change_month(int diff) {
        this.change(MONTH_VAL * (long)diff);
    }

    public static long change_month(long date, int diff) {
        return Ixe.clamp(date + MONTH_VAL * (long)diff, 0L, 9223372036854644736L);
    }

    public void change_year(int diff) {
        this.change(YEAR_VAL * (long)diff);
    }

    public static long change_year(long date, int diff) {
        return Ixe.clamp(date + YEAR_VAL * (long)diff, 0L, 9223372036854644736L);
    }

    public void set(long date) {
        this.date = date;
    }

    public static LocalDate now() {
        LocalTime time = LocalTime.now();
        LocalDate day = LocalDate.now();
        long full_time = IxeDate.first_day.until(day, ChronoUnit.DAYS) * 131072L + IxeTime.time(time.getHour(), time.getMinute(), time.getSecond(), time.getNano());
        if (current_time == selected_time) {
            selected_time = full_time;
        }
        current_time = full_time;
        return day;
    }

    public String toString() {
        String s = "";
        for (int i = term_length - 1; i >= 0; --i) {
            long x = this.get(i);
            s = s + (char)(x < 10L ? 48L + x : 65L + x - 10L);
            if (i == 0) continue;
            s = s + '\u2022';
        }
        return s + "\n" + this.date;
    }

    static {
        now = Date.now();
    }
}

