/*
 * Decompiled with CFR 0.152.
 */
package pkg_log;

import java.util.Comparator;
import pkg_log.LogLocation;
import pkg_log.LogType;

public class Log {
    public String title = "";
    public String description = "";
    public LogLocation location = null;
    public LogType type = null;
    public boolean active = false;
    public long time_start = 0L;
    public long time_end = 0L;
    public static Comparator<Log> comparator = new Comparator<Log>(){

        @Override
        public int compare(Log o1, Log o2) {
            if (o1.time_start == o2.time_start) {
                return 0;
            }
            return o1.time_start < o2.time_start ? -1 : 1;
        }
    };

    public Log(long time_start) {
        this.time_start = time_start;
        this.time_end = time_start;
        this.active = true;
    }

    public Log(Log log) {
        this(log.title, log.active, log.time_start, log.time_end, log.location, log.type, log.description);
    }

    public Log(String title, boolean active, long time_start, long time_end, LogLocation location, LogType type, String description) {
        this.title = title;
        this.description = description;
        this.location = location;
        this.type = type;
        this.active = active;
        this.time_start = time_start;
        this.time_end = time_end;
    }

    public Log(Log log, long day_of_time) {
        this.title = log.title;
        this.active = true;
        this.description = log.description;
        this.location = log.location;
        this.type = log.type;
        this.time_start = day_of_time * 131072L + log.time_start % 131072L;
        this.time_end = day_of_time * 131072L + log.time_end % 131072L;
    }

    public String toString() {
        String color = this.active ? "#000000" : "#888888";
        String str = this.title + " " + this.description + " " + this.location.name + " " + this.type.name + " " + this.time_start + " " + this.time_end;
        return "<html><font color='#" + this.type.hex() + "'>\u25a0</font><font color='" + color + "'>" + str + "</font></html>";
    }
}

