/*
 * Decompiled with CFR 0.152.
 */
package pkg_list;

import java.util.ArrayList;
import pkg_list.ListPage;

public class Lists {
    private final ArrayList<ListPage> pages = new ArrayList();
    private long lowest_type = -1L;
    private long highest_type = -1L;

    public void clear() {
        this.pages.clear();
        this.update_fields();
    }

    private void update_fields(long type) {
        if (type < this.lowest_type) {
            this.lowest_type = type;
        }
        if (type > this.highest_type) {
            this.highest_type = type;
        }
    }

    private void update_fields() {
        this.lowest_type = -1L;
        this.highest_type = -1L;
        for (ListPage page : this.pages) {
            this.update_fields(page.type);
        }
    }

    public void add_page(ListPage page) {
        this.pages.add(page);
        this.update_fields(page.type);
    }

    public void add_pages(ArrayList<ListPage> pages) {
        this.pages.addAll(pages);
        for (ListPage page : pages) {
            this.update_fields(page.type);
        }
    }

    public void remove_page(int index) {
        this.pages.remove(index);
        this.update_fields();
    }

    public long get_lowest_type() {
        return this.lowest_type;
    }

    public long get_highest_type() {
        return this.highest_type;
    }

    public ArrayList<ListPage> get_lowest_pages() {
        return this.get_pages(this.lowest_type);
    }

    public ArrayList<ListPage> get_highest_page() {
        return this.get_pages(this.highest_type);
    }

    public int page_count() {
        return this.pages.size();
    }

    public int page_count(long type) {
        int count = 0;
        for (ListPage page : this.pages) {
            if (type != page.type) continue;
            ++count;
        }
        return this.pages.size();
    }

    public ListPage get_page(long type) {
        for (ListPage page : this.pages) {
            if (type != page.type) continue;
            return page;
        }
        return null;
    }

    public ArrayList<ListPage> get_pages(long type) {
        ArrayList<ListPage> type_pages = new ArrayList<ListPage>();
        for (ListPage page : this.pages) {
            if (type != page.type) continue;
            type_pages.add(page);
        }
        return type_pages;
    }

    public ArrayList<ListPage> get_all_pages() {
        return this.pages;
    }

    public ListPage get_page_at(int index) {
        return this.pages.get(index);
    }

    public String toString() {
        String s = "";
        for (ListPage page : this.pages) {
            s = s + page + "\n";
        }
        return s;
    }
}

