/*
 * Decompiled with CFR 0.152.
 */
package pkg_list;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import pkg_list.ListCoder;
import pkg_list.ListPage;
import pkg_list.ListVal;
import pkg_list.Lists;

public class ListEncoder
extends ListCoder {
    private static OutputStream out = null;

    public static void open(File file, boolean append, Lists lists) throws IOException {
        out = new FileOutputStream(file, append);
        ListEncoder.write(lists);
        ListEncoder.close();
    }

    private static void close() throws IOException {
        out.close();
    }

    private static void write(Lists ll) throws IOException {
        for (ListPage page : ll.get_all_pages()) {
            ListEncoder.write(page);
        }
    }

    private static void write(ListPage page) throws IOException {
        buffer_it = 0;
        ListEncoder.write_long(page.raw_size());
        ListEncoder.write_long(page.type);
        for (long key : page.map.keySet()) {
            ListEncoder.write_long(key);
            ListEncoder.write_listval(page.map.get(key));
        }
        if (buffer_it != 0) {
            ListEncoder.buffer();
        }
    }

    private static void write_byte(byte write) throws IOException {
        if (buffer_it == 65536) {
            ListEncoder.buffer();
        }
        ListEncoder.buffer[ListEncoder.buffer_it++] = write;
    }

    private static void write_long(long write) throws IOException {
        ListEncoder.write_long(write, 8);
    }

    private static void write_long(long write, int encode) throws IOException {
        int x = 65536 - buffer_it;
        if (x >= encode) {
            for (int i = encode - 1; i >= 0; --i) {
                ListEncoder.buffer[ListEncoder.buffer_it + i] = (byte)(write & 0xFFL);
                write >>= 8;
            }
            buffer_it += encode;
        } else {
            int i;
            long partial_write = write;
            for (i = encode - 1; i >= x; --i) {
                partial_write >>= 8;
            }
            for (i = x - 1; i >= 0; --i) {
                ListEncoder.buffer[ListEncoder.buffer_it + i] = (byte)(partial_write & 0xFFL);
                partial_write >>= 8;
            }
            buffer_it += x;
            ListEncoder.buffer();
            for (i = encode - 1; i >= x; --i) {
                ListEncoder.buffer[ListEncoder.buffer_it + i] = (byte)(write & 0xFFL);
                write >>= 8;
            }
            buffer_it += encode - x;
        }
    }

    private static void write_listval(ListVal val) throws IOException {
        byte[] bytes = val.bytes;
        int encode_size = bytes.length == 0 ? 0 : (int)(Math.log(bytes.length) / Math.log(256.0));
        if (encode_size >= 8) {
            throw new IOException("Error: Value too big");
        }
        ListEncoder.write_byte((byte)(encode_size + val.type * 8));
        ListEncoder.write_long(bytes.length, encode_size + 1);
        for (int i = 0; i < bytes.length; ++i) {
            if (buffer_it == 65536) {
                ListEncoder.buffer();
                buffer_it = 0;
            }
            ListEncoder.buffer[ListEncoder.buffer_it++] = bytes[i];
        }
    }

    private static void buffer() throws IOException {
        ListEncoder.io_log();
        out.write(buffer, 0, buffer_it);
        buffer_it = 0;
    }
}

