/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout_tab_cell;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pkg_graphic.ThinButton;
import pkg_ixe.Ixe;
import pkg_layout_tab_cell.DayCell;
import pkg_log.LogType;

public class TypeCell
extends JPanel {
    private ThinButton btn_delete = new ThinButton("Delete");
    private ThinButton btn_save = new ThinButton("Save");
    private LogType selected = null;
    private DefaultListModel model = new DefaultListModel();
    private JList list = new JList(this.model);
    private JScrollPane scroller = new JScrollPane(this.list);
    private int[] color = new int[3];
    private JSlider red;
    private JSlider green;
    private JSlider blue;
    private JLabel red_lbl = new JLabel(" ", 0);
    private JLabel green_lbl = new JLabel(" ", 0);
    private JLabel blue_lbl = new JLabel(" ", 0);
    private JLabel color_lbl = new JLabel(" ");
    private boolean color_lock = false;
    private JTextField type_field;
    private DayCell cell;
    private ArrayList<LogType> data;

    public TypeCell(DayCell cell) {
        super(new BorderLayout());
        this.cell = cell;
        this.data = cell.get_window().log_types;
        this.setBorder(BorderFactory.createTitledBorder("Type"));
        this.list.setSelectionMode(0);
        this.red = new JSlider(0, 0, 255, 0);
        this.red.setPaintTicks(false);
        this.red.setPaintLabels(false);
        this.red.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    int val = source.getValue();
                    TypeCell.this.update_color(val, TypeCell.this.color[1], TypeCell.this.color[2]);
                }
            }
        });
        this.green = new JSlider(0, 0, 255, 0);
        this.green.setPaintTicks(false);
        this.green.setPaintLabels(false);
        this.green.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    int val = source.getValue();
                    TypeCell.this.update_color(TypeCell.this.color[0], val, TypeCell.this.color[2]);
                }
            }
        });
        this.blue = new JSlider(0, 0, 255, 0);
        this.blue.setPaintTicks(false);
        this.blue.setPaintLabels(false);
        this.blue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    int val = source.getValue();
                    TypeCell.this.update_color(TypeCell.this.color[0], TypeCell.this.color[1], val);
                }
            }
        });
        int col_out_width = 50;
        JPanel slider_pnl = new JPanel(new BorderLayout());
        JPanel title_pnl = new JPanel(new GridLayout(3, 1));
        JPanel color_pnl = new JPanel(new GridLayout(3, 1));
        JPanel value_pnl = new JPanel(new GridLayout(3, 1));
        title_pnl.add(new JLabel("Red"));
        title_pnl.add(new JLabel("Green"));
        title_pnl.add(new JLabel("Blue"));
        color_pnl.add(this.red);
        color_pnl.add(this.green);
        color_pnl.add(this.blue);
        value_pnl.add(this.red_lbl);
        value_pnl.add(this.green_lbl);
        value_pnl.add(this.blue_lbl);
        this.red_lbl.setPreferredSize(new Dimension(col_out_width, 0));
        this.green_lbl.setPreferredSize(new Dimension(col_out_width, 0));
        this.blue_lbl.setPreferredSize(new Dimension(col_out_width, 0));
        slider_pnl.add((Component)title_pnl, "West");
        slider_pnl.add((Component)color_pnl, "Center");
        slider_pnl.add((Component)value_pnl, "East");
        JLabel type_lbl = new JLabel("Name");
        type_lbl.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 20));
        this.type_field = new JTextField("Type A");
        JPanel pnl_north = new JPanel(new BorderLayout());
        pnl_north.add((Component)type_lbl, "West");
        pnl_north.add((Component)this.type_field, "Center");
        this.color_lbl.setPreferredSize(new Dimension(col_out_width, 0));
        this.color_lbl.setOpaque(true);
        pnl_north.add((Component)this.color_lbl, "East");
        JPanel pnl_border = new JPanel(new BorderLayout());
        pnl_border.add((Component)pnl_north, "North");
        pnl_border.add((Component)slider_pnl, "Center");
        this.add((Component)pnl_border, "North");
        this.init_scroller();
        this.init_buttons();
        this.clear();
        this.update_list();
    }

    private void init_buttons() {
        this.btn_delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = TypeCell.this.list.getSelectedIndex();
                if (index >= 0 && index < TypeCell.this.data.size()) {
                    TypeCell.this.data.remove(TypeCell.this.list.getSelectedIndex());
                    TypeCell.this.clear();
                    TypeCell.this.update_list();
                }
            }
        });
        this.btn_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TypeCell.this.selected != null) {
                    TypeCell.this.selected.set(TypeCell.this.type_field.getText(), TypeCell.this.color[0], TypeCell.this.color[1], TypeCell.this.color[2]);
                    TypeCell.this.update_list();
                }
            }
        });
        JPanel grid = new JPanel(new GridLayout(1, 2));
        grid.add(this.btn_delete);
        grid.add(this.btn_save);
        JPanel border = new JPanel(new BorderLayout());
        border.add((Component)grid, "East");
        this.add((Component)border, "South");
    }

    private void init_scroller() {
        this.list.setBorder(BorderFactory.createTitledBorder("Types"));
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int index = TypeCell.this.list.getSelectedIndex();
                    if (index >= 0 && index < TypeCell.this.data.size()) {
                        TypeCell.this.update((LogType)TypeCell.this.data.get(TypeCell.this.list.getSelectedIndex()));
                    } else {
                        TypeCell.this.clear();
                    }
                }
            }
        });
        JPopupMenu popup = new JPopupMenu();
        JMenuItem add_location = new JMenuItem("Create new type...");
        add_location.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TypeCell.this.data.size() < Integer.MAX_VALUE) {
                    TypeCell.this.data.add(new LogType("New type", 0));
                    TypeCell.this.update_list();
                    TypeCell.this.list.setSelectedIndex(TypeCell.this.data.size() - 1);
                }
            }
        });
        popup.add(add_location);
        this.list.setComponentPopupMenu(popup);
    }

    private void update_color(int r, int g, int b) {
        if (!this.color_lock) {
            this.color_lock = true;
            this.color[0] = r;
            this.color[1] = g;
            this.color[2] = b;
            this.red_lbl.setText(Ixe.rax(r));
            this.green_lbl.setText(Ixe.rax(g));
            this.blue_lbl.setText(Ixe.rax(b));
            this.red.setValue(r);
            this.green.setValue(g);
            this.blue.setValue(b);
            this.color_lbl.setBackground(new Color(r, g, b));
            this.color_lock = false;
        }
    }

    public void update(LogType type) {
        if (type == null) {
            this.clear();
        } else {
            this.selected = type;
            this.type_field.setText(type.name);
            this.update_color(this.selected.red(), this.selected.green(), this.selected.blue());
            this.setVisible(true);
        }
    }

    public void clear() {
        this.selected = null;
        this.type_field.setText("");
        this.update_color(0, 0, 0);
        this.setVisible(false);
    }

    public JScrollPane get_scroller() {
        return this.scroller;
    }

    public void update_list() {
        LogType selected = this.selected();
        this.model.clear();
        for (LogType l : this.data) {
            this.model.addElement(l.toString());
        }
        if (selected != null) {
            this.list.setSelectedIndex(this.data.indexOf(selected));
        }
        this.cell.reset_log_types(this.data);
    }

    private LogType selected() {
        int index = this.list.getSelectedIndex();
        return index >= 0 && index < this.data.size() ? this.data.get(index) : null;
    }

    public void set_selected(LogType item) {
        if (item == null) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(this.data.indexOf(item));
        }
    }
}

