/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout_tab_cell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pkg_ixe.Ixe;
import pkg_ixe.IxeConst;
import pkg_layout.Window;

public class NoteCell
extends JPanel {
    private JLabel date_str = new JLabel("test note", 0);
    private JTextArea area = new JTextArea();
    private long key = -1L;
    private int type = -1;
    private HashMap<Long, String> map = null;
    private Dimension dim = new Dimension();
    private Window window;

    public NoteCell(Window window) {
        super(new BorderLayout());
        this.window = window;
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
        this.area.setBorder(IxeConst.swing_EMPTY_BORDER);
        JScrollPane scroller = new JScrollPane(this.area);
        this.setPreferredSize(this.dim);
        this.add((Component)this.date_str, "North");
        this.add((Component)scroller, "Center");
    }

    public void set(int type, HashMap<Long, String> map, long key) {
        this.put();
        this.type = type;
        this.map = map;
        this.key = key;
        String type_str = "";
        switch (type) {
            case 3: {
                type_str = "Day ";
                break;
            }
            case 2: {
                type_str = "Week ";
                break;
            }
            case 1: {
                type_str = "Month ";
                break;
            }
            case 0: {
                type_str = "Year ";
            }
        }
        if (this.window.time_format) {
            type_str = type_str.toUpperCase();
        }
        this.date_str.setText(type_str + Ixe.rax(key));
        this.area.setText(map == null ? "" : map.get(key));
    }

    public void put() {
        if (this.map != null && this.key != -1L) {
            this.map.put(this.key, this.area.getText());
        }
    }

    public String get() {
        return this.area.getText();
    }

    public void update_size(int frame_size) {
        this.dim.width = frame_size / 4;
    }

    public void unset() {
        this.date_str.setText("");
        this.area.setText("");
        this.type = -1;
        this.map = null;
        this.key = -1L;
    }
}

