/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout_tab_cell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pkg_graphic.LimitTextField;
import pkg_graphic.ThinButton;
import pkg_layout_tab_cell.DayCell;
import pkg_log.LogLocation;

public class LocationCell
extends JPanel {
    private JTextArea comment;
    private JLabel name_label = new JLabel("Name");
    private JTextField name_field = new JTextField();
    private LimitTextField[] key_fields = new LimitTextField[5];
    private JTextField[] value_fields = new JTextField[5];
    private JButton btn_remove = new JButton("-");
    private JButton btn_add = new JButton("+");
    private ThinButton btn_delete = new ThinButton("Delete");
    private ThinButton btn_save = new ThinButton("Save");
    private ArrayList<LogLocation> data;
    private LogLocation selected = null;
    private int selected_field_nb = 0;
    private DefaultListModel model = new DefaultListModel();
    private JList list = new JList(this.model);
    private JScrollPane scroller = new JScrollPane(this.list);
    private DayCell cell;

    public LocationCell(DayCell cell) {
        super(new GridLayout(1, 2));
        this.cell = cell;
        this.data = cell.get_window().log_locations;
        this.setBorder(BorderFactory.createTitledBorder("Location"));
        this.list.setSelectionMode(0);
        for (int i = 0; i < this.key_fields.length; ++i) {
            this.key_fields[i] = new LimitTextField(4, true);
            this.value_fields[i] = new JTextField();
        }
        JPanel pnl_border = new JPanel(new BorderLayout());
        JPanel pnl_grid1 = new JPanel(new GridLayout(7, 1));
        JPanel pnl_grid3 = new JPanel(new GridLayout(7, 1));
        this.name_label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        pnl_grid1.add(this.name_label);
        pnl_grid3.add(this.name_field);
        for (int i = 0; i < this.key_fields.length; ++i) {
            pnl_grid1.add(this.key_fields[i]);
            pnl_grid3.add(this.value_fields[i]);
        }
        pnl_grid1.add(new JLabel(""));
        this.btn_remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationCell.this.remove_field();
            }
        });
        this.btn_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationCell.this.add_field();
            }
        });
        JPanel field_panel = new JPanel(new BorderLayout());
        JPanel field_btn_panel = new JPanel(new GridLayout(1, 2));
        field_btn_panel.add(this.btn_remove);
        field_btn_panel.add(this.btn_add);
        field_panel.add((Component)field_btn_panel, "East");
        pnl_grid3.add(field_panel);
        this.comment = new JTextArea();
        this.comment.setLineWrap(true);
        this.comment.setWrapStyleWord(true);
        this.comment.setBorder(BorderFactory.createTitledBorder("Comment"));
        this.btn_delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = LocationCell.this.list.getSelectedIndex();
                if (index >= 0 && index < LocationCell.this.data.size()) {
                    LocationCell.this.data.remove(LocationCell.this.list.getSelectedIndex());
                    LocationCell.this.clear();
                    LocationCell.this.update_list();
                }
            }
        });
        this.btn_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LocationCell.this.selected != null) {
                    String[] keys = new String[5];
                    String[] values = new String[5];
                    for (int i = 0; i < LocationCell.this.selected_field_nb; ++i) {
                        keys[i] = LocationCell.this.key_fields[i].getText();
                        values[i] = LocationCell.this.value_fields[i].getText();
                    }
                    LocationCell.this.selected.set(LocationCell.this.name_field.getText(), keys, values, LocationCell.this.comment.getText());
                    LocationCell.this.update_list();
                }
            }
        });
        JPanel btn_panel = new JPanel(new BorderLayout());
        JPanel btn_panel2 = new JPanel(new GridLayout(1, 2));
        btn_panel2.add(this.btn_delete);
        btn_panel2.add(this.btn_save);
        btn_panel.add((Component)btn_panel2, "East");
        JPanel comment_panel = new JPanel(new BorderLayout());
        comment_panel.add((Component)this.comment, "Center");
        comment_panel.add((Component)btn_panel, "South");
        pnl_border.add((Component)pnl_grid1, "West");
        pnl_border.add((Component)pnl_grid3, "Center");
        JPanel pnl_border2 = new JPanel(new BorderLayout());
        pnl_border2.add((Component)pnl_border, "North");
        this.add(pnl_border2);
        this.add(comment_panel);
        this.init_scroller();
        this.clear();
        this.update_list();
    }

    private void remove_field() {
        --this.selected_field_nb;
        this.enable_fields();
    }

    private void add_field() {
        ++this.selected_field_nb;
        this.enable_fields();
    }

    private void init_scroller() {
        this.list.setBorder(BorderFactory.createTitledBorder("Locations"));
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int index = LocationCell.this.list.getSelectedIndex();
                    if (index >= 0 && index < LocationCell.this.data.size()) {
                        LocationCell.this.update((LogLocation)LocationCell.this.data.get(LocationCell.this.list.getSelectedIndex()));
                    } else {
                        LocationCell.this.clear();
                    }
                }
            }
        });
        JPopupMenu popup = new JPopupMenu();
        JMenuItem add_location = new JMenuItem("Create new location...");
        add_location.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LocationCell.this.data.size() < Integer.MAX_VALUE) {
                    LocationCell.this.data.add(new LogLocation("New location"));
                    LocationCell.this.update_list();
                    LocationCell.this.list.setSelectedIndex(LocationCell.this.data.size() - 1);
                }
            }
        });
        popup.add(add_location);
        this.list.setComponentPopupMenu(popup);
    }

    public void update(LogLocation location) {
        if (location == null) {
            this.clear();
        } else {
            this.selected = location;
            this.selected_field_nb = location.field_nb();
            this.name_field.setText(this.selected.name);
            for (int i = 0; i < 5; ++i) {
                this.key_fields[i].setText(this.selected.key[i]);
                this.value_fields[i].setText(this.selected.value[i]);
            }
            this.comment.setText(this.selected.comment);
            this.enable_fields();
            this.setVisible(true);
        }
    }

    public void clear() {
        this.selected = null;
        this.selected_field_nb = 0;
        this.name_field.setText("");
        this.setVisible(false);
        this.comment.setText("");
    }

    private void enable_fields() {
        int nb = this.selected == null ? 0 : this.selected_field_nb;
        for (int i = 0; i < this.key_fields.length; ++i) {
            this.key_fields[i].setVisible(i < nb);
            this.value_fields[i].setVisible(i < nb);
        }
        this.btn_remove.setEnabled(this.selected != null && nb > 0);
        this.btn_add.setEnabled(this.selected != null && nb < 5);
        this.btn_delete.setEnabled(this.selected != null);
        this.btn_save.setEnabled(this.selected != null);
        this.name_field.setVisible(this.selected != null);
        this.name_label.setVisible(this.selected != null);
        this.comment.setVisible(this.selected != null);
    }

    public JScrollPane get_scroller() {
        return this.scroller;
    }

    public void update_list() {
        LogLocation selected = this.selected();
        this.model.clear();
        for (LogLocation l : this.data) {
            this.model.addElement(l.toString());
        }
        if (selected != null) {
            this.list.setSelectedIndex(this.data.indexOf(selected));
        }
        this.cell.reset_log_locations(this.data);
    }

    private LogLocation selected() {
        int index = this.list.getSelectedIndex();
        return index >= 0 && index < this.data.size() ? this.data.get(index) : null;
    }

    public void set_selected(LogLocation item) {
        if (item == null) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(this.data.indexOf(item));
        }
    }
}

