/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout_tab_cell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultRowSorter;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import pkg_graphic.LogCellEditor;
import pkg_graphic.LogTableModel;
import pkg_graphic.RepeatDialog;
import pkg_graphic.TimeCellEditor;
import pkg_layout.Window;
import pkg_layout_tab_cell.CalendarCell;
import pkg_layout_tab_cell.LocationCell;
import pkg_layout_tab_cell.TypeCell;
import pkg_log.Log;
import pkg_log.LogLocation;
import pkg_log.LogType;
import pkg_logic.Date;

public class DayCell
extends CalendarCell {
    private RepeatDialog repeat;
    private LogTableModel table_model;
    private JTable table;
    private JPopupMenu popup = new JPopupMenu();
    private int min_col_width = 80;
    private int max_col_width = 200;
    private int[] column_size = new int[]{40, 120, 80, 80, 100, 100, Integer.MAX_VALUE};
    private TableColumn type_column;
    private TableColumn location_column;
    private LocationCell location;
    private TypeCell type;

    public DayCell(Window window) {
        super(window);
        this.setLayout(new BorderLayout());
        this.repeat = new RepeatDialog();
        this.table_model = new LogTableModel();
        this.table = new JTable(this.table_model);
        this.table.setAutoResizeMode(3);
        this.table.setAutoCreateRowSorter(true);
        ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
        DefaultRowSorter sorter = (DefaultRowSorter)this.table.getRowSorter();
        sorter.setSortsOnUpdates(true);
        list.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        sorter.setSortKeys(list);
        sorter.sort();
        DefaultTableCellRenderer align_center_renderer_renderer = new DefaultTableCellRenderer();
        align_center_renderer_renderer.setHorizontalAlignment(0);
        TableColumn column = null;
        for (int i = 0; i < this.table_model.col_nb; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            if (i == 2 || i == 3) {
                column.setCellRenderer(align_center_renderer_renderer);
                column.setCellEditor(new TimeCellEditor());
            }
            if (i == 4 || i == 5) {
                column.setCellEditor(new LogCellEditor());
            }
            column.setPreferredWidth(this.column_size[i]);
            column.setMinWidth(Math.min(this.min_col_width, this.column_size[i]));
            column.setMaxWidth(Math.max(this.max_col_width, this.column_size[i]));
        }
        this.location_column = this.table.getColumnModel().getColumn(4);
        this.type_column = this.table.getColumnModel().getColumn(5);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = DayCell.this.table.getSelectedRow();
                if (index >= 0) {
                    index = DayCell.this.table.convertRowIndexToView(index);
                    Log l = DayCell.this.table_model.get_log_at(index);
                    if (l != null) {
                        if (l.type != null) {
                            DayCell.this.type.update(l.type);
                        }
                        if (l.location != null) {
                            DayCell.this.location.update(l.location);
                        }
                    }
                }
            }
        });
        this.popup();
        JScrollPane scroller = new JScrollPane(this.table, 20, 30);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scroller, "Center");
        this.location = new LocationCell(this);
        this.type = new TypeCell(this);
        this.table_model.ref(this.location, this.type);
    }

    public void reset_log_types(ArrayList<LogType> candidates) {
        ((LogCellEditor)this.type_column.getCellEditor()).reset_candidates(candidates);
        for (Log l : this.table_model.get_data()) {
            if (candidates.contains(l.type)) continue;
            l.type = null;
        }
    }

    public void reset_log_locations(ArrayList<LogLocation> candidates) {
        ((LogCellEditor)this.location_column.getCellEditor()).reset_candidates(candidates);
        for (Log l : this.table_model.get_data()) {
            if (candidates.contains(l.location)) continue;
            l.location = null;
        }
    }

    private void popup() {
        final JMenuItem popup_repeat = new JMenuItem("Repeat row...");
        final JMenuItem popup_add = new JMenuItem("Add new row");
        final JMenuItem popup_copy = new JMenuItem("Copy row");
        final JMenuItem popup_delete = new JMenuItem("Delete row");
        final JMenuItem popup_delete_all = new JMenuItem("Delete all");
        popup_repeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DayCell.this.repeat();
            }
        });
        popup_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DayCell.this.add_row(new Log(Date.selected_time / 131072L * 131072L));
            }
        });
        popup_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = DayCell.this.table.getSelectedRow();
                if (index >= 0) {
                    index = DayCell.this.table.convertRowIndexToView(index);
                    DayCell.this.add_row(new Log(DayCell.this.table_model.get_log_at(index)));
                }
            }
        });
        popup_delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DayCell.this.delete_row();
            }
        });
        popup_delete_all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DayCell.this.delete_all();
            }
        });
        this.popup.add(popup_repeat);
        this.popup.add(popup_add);
        this.popup.add(popup_copy);
        this.popup.addSeparator();
        this.popup.add(popup_delete);
        this.popup.add(popup_delete_all);
        this.table.setComponentPopupMenu(this.popup);
        this.popup.addPopupMenuListener(new PopupMenuListener(){
            final /* synthetic */ DayCell this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int rowAtPoint = this$0.table.rowAtPoint(SwingUtilities.convertPoint(this$0.popup, new Point(0, 0), this$0.table));
                        if (rowAtPoint > -1) {
                            this$0.table.setRowSelectionInterval(rowAtPoint, rowAtPoint);
                        }
                        popup_add.setText(Date.selected_time / 131072L < Date.current_time / 131072L ? "Add old row" : "Add new row");
                        popup_repeat.setEnabled(rowAtPoint > -1);
                        popup_copy.setEnabled(rowAtPoint > -1);
                        popup_delete.setEnabled(rowAtPoint > -1);
                        popup_delete_all.setEnabled(!this$0.table_model.get_data().isEmpty());
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public void add_row(Log log) {
        this.window.add_log(log);
        this.update_table_data();
    }

    public void delete_row() {
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            index = this.table.convertRowIndexToView(index);
            this.window.remove_log(this.table_model.get_log_at(index));
        }
        this.update_table_data();
    }

    public void delete_all() {
        this.window.remove_all_log(Date.selected_time);
        this.update_table_data();
    }

    public void repeat() {
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            index = this.table.convertRowIndexToView(index);
            Log l = this.table_model.get_data().get(index);
            this.repeat.open(l);
            long day_of_time = l.time_start / 131072L + 1L;
            for (int i = 0; i < this.repeat.get_count(); ++i) {
                if (this.repeat.repeat(i)) {
                    this.add_row(new Log(l, day_of_time));
                }
                ++day_of_time;
            }
        }
    }

    public LocationCell get_location() {
        return this.location;
    }

    public TypeCell get_type() {
        return this.type;
    }

    public void update_table_data() {
        int index;
        this.table_model.get_data().clear();
        long day_of_time = Date.selected_time / 131072L;
        long min = day_of_time * 131072L;
        long max = min + 131072L;
        for (int i = index = this.window.log_index(min); i < this.window.logs.size(); ++i) {
            Log l = this.window.logs.get(i);
            if (l.time_start >= max) break;
            this.table_model.get_data().add(l);
        }
        this.table_model.fireTableDataChanged();
    }
}

