/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout_tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pkg_ixe.IxeDate;
import pkg_layout.Window;
import pkg_layout_tab.CalendarTab;
import pkg_layout_tab_cell.YearCell;
import pkg_logic.Date;
import pkg_logic.RelativeDate;

public class YearTab
extends CalendarTab {
    private YearCell[][] rel_cells;
    private YearCell[][] abs_cells;
    private JPanel[] content = new JPanel[2];

    public YearTab(Window window) {
        super(window);
        this.content[0] = this.build_relative();
        this.content[1] = this.build_absolute();
        this.add((Component)this.build_north(), "North");
        this.add((Component)this.content[0], "Center");
    }

    private JPanel build_relative() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.rel_cells = new YearCell[4][3];
        JPanel pnl_grid = new JPanel(new GridLayout(this.rel_cells.length, this.rel_cells[0].length));
        for (int i = 0; i < this.rel_cells.length; ++i) {
            for (int j = 0; j < this.rel_cells[0].length; ++j) {
                this.rel_cells[i][j] = new YearCell(this.window);
                this.rel_cells[i][j].update_data(0L, 0L, false, false);
                pnl_grid.add(this.rel_cells[i][j]);
            }
        }
        JScrollPane scroller = new JScrollPane(pnl_grid);
        pnl.add((Component)scroller, "Center");
        return pnl;
    }

    private JPanel build_absolute() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.abs_cells = new YearCell[4][4];
        JPanel pnl_grid = new JPanel(new GridLayout(this.abs_cells.length, this.abs_cells[0].length));
        for (int i = 0; i < this.abs_cells.length; ++i) {
            for (int j = 0; j < this.abs_cells[0].length; ++j) {
                this.abs_cells[i][j] = new YearCell(this.window);
                this.abs_cells[i][j].update_data(0L, 0L, false, false);
                pnl_grid.add(this.abs_cells[i][j]);
            }
        }
        JScrollPane scroller = new JScrollPane(pnl_grid);
        pnl.add((Component)scroller, "Center");
        return pnl;
    }

    @Override
    public void update_data() {
        int j;
        int i;
        super.update_data();
        RelativeDate d = new RelativeDate(Date.selected_time);
        RelativeDate d_current = new RelativeDate(Date.current_time);
        long time = IxeDate.day_of_time(d.get_year(), 0, 0) * 131072L;
        long current_month = d.get_year() == d_current.get_year() ? (long)d_current.get_month() : -1L;
        int it = 0;
        for (i = 0; i < this.rel_cells.length; ++i) {
            for (j = 0; j < this.rel_cells[0].length; ++j) {
                this.rel_cells[i][j].update_data(time, it, (long)it == current_month, true);
                time += (long)IxeDate.days_in_month(d.get_year(), it) * 131072L;
                ++it;
            }
        }
        time = Date.first_date_of_year(Date.selected_time);
        current_month = Date.get(6, true, Date.current_time);
        for (i = 0; i < this.abs_cells.length; ++i) {
            for (j = 0; j < this.abs_cells[0].length; ++j) {
                int month_of_time = (int)(time / Date.MONTH_VAL);
                this.abs_cells[i][j].update_data(time, month_of_time, (long)month_of_time == current_month, true);
                time += Date.MONTH_VAL;
            }
        }
    }

    @Override
    public void set_time_format(boolean time_format) {
        super.set_time_format(time_format);
        this.remove(this.content[0]);
        this.remove(this.content[1]);
        int type = time_format ? 1 : 0;
        this.activation();
        this.add((Component)this.content[type], "Center");
        this.revalidate();
        this.repaint();
    }

    @Override
    public void decrement_date() {
        if (this.time_format) {
            Date.selected_time = Date.change_year(Date.selected_time, -1);
        } else {
            RelativeDate d = new RelativeDate(Date.selected_time);
            d.change_year(-1L);
            Date.selected_time = d.date.date;
        }
        this.activation();
        this.window.open_date(Date.selected_time);
    }

    @Override
    public void increment_date() {
        if (this.time_format) {
            Date.selected_time = Date.change_year(Date.selected_time, 1);
        } else {
            RelativeDate d = new RelativeDate(Date.selected_time);
            d.change_year(1L);
            Date.selected_time = d.date.date;
        }
        this.activation();
        this.window.open_date(Date.selected_time);
    }

    @Override
    protected void activation() {
        long time_next;
        long time_previous;
        if (this.time_format) {
            time_previous = Date.selected_time - Date.YEAR_VAL;
            time_next = Date.selected_time + Date.YEAR_VAL;
        } else {
            RelativeDate d1 = new RelativeDate(Date.selected_time);
            RelativeDate d2 = new RelativeDate(Date.selected_time);
            d1.change_year(-1L);
            d2.change_year(1L);
            time_previous = d1.date.date;
            time_next = d2.date.date;
        }
        this.btn_previous.setEnabled(time_previous >= 0L);
        this.btn_next.setEnabled(time_next < 9223372036854644736L);
    }

    @Override
    public void update_size() {
        int j;
        int i;
        int width = this.window.getWidth();
        int note_width = width - this.window.note.getWidth();
        int w = (int)((double)note_width / (double)(this.rel_cells[0].length + 1));
        for (i = 0; i < this.rel_cells.length; ++i) {
            for (j = 0; j < this.rel_cells[0].length; ++j) {
                this.rel_cells[i][j].update_size(w, 0);
            }
        }
        w = (int)((double)note_width / (double)(this.abs_cells[0].length + 1));
        for (i = 0; i < this.abs_cells.length; ++i) {
            for (j = 0; j < this.abs_cells[0].length; ++j) {
                this.abs_cells[i][j].update_size(w, 0);
            }
        }
    }
}

