/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout_tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pkg_ixe.IxeDate;
import pkg_layout.Window;
import pkg_layout_tab.CalendarTab;
import pkg_layout_tab_cell.WeekCell;
import pkg_logic.Date;
import pkg_logic.RelativeDate;

public class WeekTab
extends CalendarTab {
    private WeekCell[] cells = new WeekCell[8];

    public WeekTab(Window window) {
        super(window);
        this.setLayout(new BorderLayout());
        JPanel grid = new JPanel(new GridLayout(1, 8));
        for (int i = 0; i < 8; ++i) {
            this.cells[i] = new WeekCell(window);
            grid.add(this.cells[i]);
        }
        this.add((Component)this.build_north(), "North");
        this.add((Component)grid, "Center");
    }

    @Override
    public void update_data() {
        super.update_data();
        RelativeDate d = new RelativeDate(Date.selected_time);
        int first_day = IxeDate.day_of_week(d.get_year(), d.get_month(), d.get_day());
        long time = Date.selected_time - (long)first_day * 131072L;
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].update_data(time, this.time_format ? time / 131072L : (long)IxeDate.day_of_month(time / 131072L), time / 131072L == Date.current_time / 131072L, true);
            time += 131072L;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < WeekTab.this.cells.length; ++i) {
                    WeekTab.this.cells[i].reset_scrollbar();
                }
            }
        });
    }

    @Override
    public void set_time_format(boolean time_format) {
        super.set_time_format(time_format);
    }

    @Override
    public void decrement_date() {
        if (this.time_format) {
            Date.selected_time = Date.change_week(Date.selected_time, -1);
        } else {
            RelativeDate d = new RelativeDate(Date.selected_time);
            d.dec_week();
            Date.selected_time = d.date.date;
        }
        this.activation();
        this.window.open_date(Date.selected_time);
    }

    @Override
    public void increment_date() {
        if (this.time_format) {
            Date.selected_time = Date.change_week(Date.selected_time, 1);
        } else {
            RelativeDate d = new RelativeDate(Date.selected_time);
            d.inc_week();
            Date.selected_time = d.date.date;
        }
        this.activation();
        this.window.open_date(Date.selected_time);
    }

    @Override
    protected void activation() {
        long time_previous = Date.selected_time - Date.WEEK_VAL;
        long time_next = Date.selected_time + Date.WEEK_VAL;
        this.btn_previous.setEnabled(time_previous >= 0L);
        this.btn_next.setEnabled(time_next < 9223372036854644736L);
    }

    @Override
    public void update_size() {
        int width = this.window.getWidth();
        int note_width = width - this.window.note.getWidth();
        int w = (int)((double)note_width / (double)(this.cells.length + 1));
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].update_size(w, 0);
        }
    }
}

