/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout_tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pkg_ixe.IxeDate;
import pkg_layout.Window;
import pkg_layout_tab.CalendarTab;
import pkg_layout_tab_cell.AbsMonthCell;
import pkg_layout_tab_cell.MonthCell;
import pkg_layout_tab_cell.MonthWeekCell;
import pkg_logic.Date;
import pkg_logic.RelativeDate;

public class MonthTab
extends CalendarTab {
    private MonthCell[][] rel_cells;
    private AbsMonthCell[][] abs_cells;
    private JPanel[] content = new JPanel[2];
    private MonthWeekCell[] week_cells;
    private JPanel week_panel;

    public MonthTab(Window window) {
        super(window);
        this.content[0] = this.build_relative();
        this.content[1] = this.build_absolute();
        this.week_panel = this.build_week();
        this.add((Component)this.build_north(), "North");
        this.add((Component)this.content[0], "Center");
        this.add((Component)this.week_panel, "West");
    }

    private JPanel build_week() {
        int week_nb = 5;
        JPanel panel = new JPanel(new GridLayout(week_nb, 1));
        this.week_cells = new MonthWeekCell[week_nb];
        for (int i = 0; i < week_nb; ++i) {
            this.week_cells[i] = new MonthWeekCell(this.window);
            panel.add(this.week_cells[i]);
        }
        return panel;
    }

    private JPanel build_relative() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.rel_cells = new MonthCell[5][8];
        JPanel pnl_grid = new JPanel(new GridLayout(this.rel_cells.length, this.rel_cells[0].length));
        for (int i = 0; i < this.rel_cells.length; ++i) {
            for (int j = 0; j < this.rel_cells[0].length; ++j) {
                this.rel_cells[i][j] = new MonthCell(this.window);
                this.rel_cells[i][j].update_data(0L, 0L, false, false);
                pnl_grid.add(this.rel_cells[i][j]);
            }
        }
        JScrollPane scroller = new JScrollPane(pnl_grid);
        pnl.add((Component)scroller, "Center");
        return pnl;
    }

    private JPanel build_absolute() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.abs_cells = new AbsMonthCell[4][4];
        JPanel pnl_grid = new JPanel(new GridLayout(this.abs_cells.length, this.abs_cells[0].length));
        for (int i = 0; i < this.abs_cells.length; ++i) {
            for (int j = 0; j < this.abs_cells[0].length; ++j) {
                this.abs_cells[i][j] = new AbsMonthCell(this.window);
                this.abs_cells[i][j].update_data(0L, 0L, false, false);
                pnl_grid.add(this.abs_cells[i][j]);
            }
        }
        JScrollPane scroller = new JScrollPane(pnl_grid);
        pnl.add((Component)scroller, "Center");
        return pnl;
    }

    @Override
    public void update_data() {
        int j;
        int i;
        super.update_data();
        RelativeDate d = new RelativeDate(Date.selected_time);
        RelativeDate d2 = new RelativeDate(d.get_year(), d.get_month(), 0);
        int first_day = IxeDate.day_of_week(d2.get_year(), d2.get_month(), d2.get_day());
        int month_length = IxeDate.days_in_month(d.get_year(), d.get_month());
        int last_month = (d.get_month() + 11) % 12;
        int last_month_length = IxeDate.days_in_month(d.get_year() - (long)(last_month == 11 ? 1 : 0), last_month);
        int it = 0;
        long time = d2.date.date - (long)first_day * 131072L;
        for (i = 0; i < this.rel_cells.length; ++i) {
            for (j = 0; j < this.rel_cells[0].length; ++j) {
                boolean selected_month = true;
                int val = it - first_day;
                if (it < first_day) {
                    selected_month = false;
                    val = last_month_length - first_day + it;
                } else if (it >= first_day + month_length) {
                    selected_month = false;
                    val = it - first_day - month_length;
                }
                this.rel_cells[i][j].update_data(time, val, time / 131072L == Date.current_time / 131072L, selected_month);
                ++it;
                time += 131072L;
            }
        }
        time = Date.selected_time / Date.MONTH_VAL * Date.MONTH_VAL;
        for (i = 0; i < this.abs_cells.length; ++i) {
            for (j = 0; j < this.abs_cells[0].length; ++j) {
                this.abs_cells[i][j].update_data(time, (int)(time / Date.WEEK_VAL), time / Date.WEEK_VAL == Date.current_time / Date.WEEK_VAL, true);
                time += Date.WEEK_VAL;
            }
        }
        for (i = 0; i < this.week_cells.length; ++i) {
            time = d2.date.date + (long)i * Date.WEEK_VAL;
            this.week_cells[i].update_data(time, i, time / Date.WEEK_VAL == Date.current_time / Date.WEEK_VAL, true);
        }
    }

    @Override
    public void set_time_format(boolean time_format) {
        super.set_time_format(time_format);
        this.remove(this.content[0]);
        this.remove(this.content[1]);
        this.remove(this.week_panel);
        this.activation();
        if (time_format) {
            this.add((Component)this.content[1], "Center");
        } else {
            this.add((Component)this.content[0], "Center");
            this.add((Component)this.week_panel, "West");
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void decrement_date() {
        if (this.time_format) {
            Date.selected_time = Date.change_month(Date.selected_time, -1);
        } else {
            RelativeDate d = new RelativeDate(Date.selected_time);
            d.change_month(-1);
            Date.selected_time = d.date.date;
        }
        this.activation();
        this.window.open_date(Date.selected_time);
    }

    @Override
    public void increment_date() {
        if (this.time_format) {
            Date.selected_time = Date.change_month(Date.selected_time, 1);
        } else {
            RelativeDate d = new RelativeDate(Date.selected_time);
            d.change_month(1);
            Date.selected_time = d.date.date;
        }
        this.activation();
        this.window.open_date(Date.selected_time);
    }

    @Override
    protected void activation() {
        long time_next;
        long time_previous;
        if (this.time_format) {
            time_previous = Date.selected_time - Date.MONTH_VAL;
            time_next = Date.selected_time + Date.MONTH_VAL;
        } else {
            RelativeDate d1 = new RelativeDate(Date.selected_time);
            RelativeDate d2 = new RelativeDate(Date.selected_time);
            d1.change_month(-1);
            d2.change_month(1);
            time_previous = d1.date.date;
            time_next = d2.date.date;
        }
        this.btn_previous.setEnabled(time_previous >= 0L);
        this.btn_next.setEnabled(time_next < 9223372036854644736L);
    }

    @Override
    public void update_size() {
        int j;
        int i;
        int width = this.window.getWidth();
        int note_width = width - this.window.note.getWidth() - 77;
        int w = (int)((double)note_width / (double)(this.rel_cells[0].length + 1));
        for (i = 0; i < this.rel_cells.length; ++i) {
            for (j = 0; j < this.rel_cells[0].length; ++j) {
                this.rel_cells[i][j].update_size(w, 0);
            }
        }
        w = (int)((double)note_width / (double)(this.abs_cells[0].length + 1));
        for (i = 0; i < this.abs_cells.length; ++i) {
            for (j = 0; j < this.abs_cells[0].length; ++j) {
                this.abs_cells[i][j].update_size(w, 0);
            }
        }
    }
}

