/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout_tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import pkg_layout.Window;
import pkg_layout_tab.CalendarTab;
import pkg_layout_tab_cell.DayCell;
import pkg_layout_tab_cell.LocationCell;
import pkg_layout_tab_cell.TypeCell;
import pkg_logic.Date;
import pkg_logic.RelativeDate;

public class DayTab
extends CalendarTab {
    private DayCell cell;
    private LocationCell location;
    private TypeCell type;
    private JPanel edit_panel;
    private JPanel scroller_panel;
    private int scroller_width = 120;
    private Dimension scroller_dim = new Dimension(this.scroller_width, 0);

    public DayTab(Window window) {
        super(window);
        this.setLayout(new BorderLayout());
        this.add((Component)this.build_north(), "North");
        this.cell = new DayCell(window);
        this.location = this.cell.get_location();
        this.type = this.cell.get_type();
        this.scroller_panel = new JPanel(new GridLayout(2, 1));
        this.scroller_panel.setPreferredSize(this.scroller_dim);
        this.scroller_panel.add(this.location.get_scroller());
        this.scroller_panel.add(this.type.get_scroller());
        this.add((Component)this.scroller_panel, "West");
        this.edit_panel = new JPanel(new GridLayout(1, 2));
        this.edit_panel.add(this.location);
        this.edit_panel.add(this.type);
        JPanel main_panel = new JPanel(new BorderLayout());
        main_panel.add((Component)this.cell, "Center");
        main_panel.add((Component)this.edit_panel, "South");
        this.add((Component)main_panel, "Center");
    }

    @Override
    public void toggle_editor(boolean toggle) {
        this.edit_panel.setVisible(toggle);
        this.scroller_panel.setVisible(toggle);
        this.scroller_dim.width = toggle ? this.scroller_width : 0;
    }

    @Override
    public void update_data() {
        super.update_data();
        RelativeDate date = new RelativeDate(Date.selected_time);
        this.cell.update_table_data();
    }

    @Override
    public void set_time_format(boolean time_format) {
        super.set_time_format(time_format);
    }

    @Override
    public void decrement_date() {
        if (this.time_format) {
            Date.selected_time = Date.change_day(Date.selected_time, -1);
        } else {
            RelativeDate d = new RelativeDate(Date.selected_time);
            d.dec_day();
            Date.selected_time = d.date.date;
        }
        this.activation();
        this.window.open_date(Date.selected_time);
    }

    @Override
    public void increment_date() {
        if (this.time_format) {
            Date.selected_time = Date.change_day(Date.selected_time, 1);
        } else {
            RelativeDate d = new RelativeDate(Date.selected_time);
            d.inc_day();
            Date.selected_time = d.date.date;
        }
        this.activation();
        this.window.open_date(Date.selected_time);
    }

    @Override
    protected void activation() {
        long day = (this.time_format ? Date.selected_time : new RelativeDate((long)Date.selected_time).date.date) / 131072L;
        this.btn_previous.setEnabled(day > 0L);
        this.btn_next.setEnabled(day < 0x3FFFFFFFFFFEL);
    }

    @Override
    public void update_fields() {
        this.location.update_list();
        this.type.update_list();
    }
}

