/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_ixe.Ixe;
import pkg_ixe.IxeDate;
import pkg_ixe.IxeDialog;
import pkg_ixe.IxeTime;
import pkg_layout.Frame;
import pkg_layout.Menubar;
import pkg_layout_tab.CalendarTab;
import pkg_layout_tab.DayTab;
import pkg_layout_tab.MonthTab;
import pkg_layout_tab.WeekTab;
import pkg_layout_tab.YearTab;
import pkg_layout_tab_cell.NoteCell;
import pkg_list.ListDecoder;
import pkg_list.ListEncoder;
import pkg_list.ListPage;
import pkg_list.ListVal;
import pkg_list.ListVals;
import pkg_list.Lists;
import pkg_log.Log;
import pkg_log.LogLocation;
import pkg_log.LogType;
import pkg_logic.Date;

public class Window
extends Frame {
    public static final int YEAR_TAB = 0;
    public static final int MONTH_TAB = 1;
    public static final int WEEK_TAB = 2;
    public static final int DAY_TAB = 3;
    public static final int HOUR_TAB = 4;
    public boolean time_format = false;
    private CalendarTab[] tabs = new CalendarTab[4];
    private JTabbedPane pane = new JTabbedPane();
    public NoteCell note = new NoteCell(this);
    public HashMap<Long, String> abs_year_note = new HashMap();
    public HashMap<Long, String> abs_month_note = new HashMap();
    public HashMap<Long, String> year_note = new HashMap();
    public HashMap<Long, String> month_note = new HashMap();
    public HashMap<Long, String> week_note = new HashMap();
    public HashMap<Long, String> day_note = new HashMap();
    public ArrayList<Log> logs = new ArrayList();
    public ArrayList<LogLocation> log_locations = new ArrayList();
    public ArrayList<LogType> log_types = new ArrayList();

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.setJMenuBar(new Menubar(this));
        this.init_tab_pane();
        this.add((Component)this.note, "East");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Window.this.update_size(Window.this.getWidth());
            }
        });
        this.open_date(3);
        this.auto();
        this.fullscreen();
        this.setVisible(true);
    }

    private void update_size(int size) {
        this.note.update_size(size);
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].update_size();
        }
    }

    public void update_date() {
        this.open_date(this.pane.getSelectedIndex(), Date.selected_time);
    }

    public void open_date(int tab) {
        this.open_date(tab, Date.selected_time);
    }

    public void open_date(long time) {
        this.open_date(this.pane.getSelectedIndex(), time);
    }

    public void open_date(int tab, long time) {
        Date.selected_time = time;
        if (tab != this.pane.getSelectedIndex()) {
            this.tabs[tab].update_data();
            this.pane.setSelectedIndex(tab);
        }
        HashMap<Long, String> map = null;
        long key = 0L;
        long day_of_time = Date.selected_time / 131072L;
        int type = tab;
        switch (type) {
            case 3: {
                map = this.day_note;
                key = day_of_time;
                break;
            }
            case 2: {
                map = this.week_note;
                key = IxeDate.week_of_time(day_of_time);
                break;
            }
            case 1: {
                if (this.time_format) {
                    map = this.abs_month_note;
                    key = Date.selected_time / Date.MONTH_VAL;
                    break;
                }
                map = this.month_note;
                key = IxeDate.month_of_time(day_of_time);
                break;
            }
            case 0: {
                if (this.time_format) {
                    map = this.abs_year_note;
                    key = Date.get(7, true, Date.selected_time);
                    break;
                }
                map = this.year_note;
                key = IxeDate.year_of_time(day_of_time);
            }
        }
        this.note.set(type, map, key);
        this.update_data();
        this.update_tab_titles();
    }

    private void update_tab_titles() {
        String day_str = "";
        String week_str = "";
        String month_str = "";
        String year_str = "";
        if (this.time_format) {
            day_str = "DAY " + Ixe.rax(Date.get(4, false, Date.selected_time));
            week_str = "WEEK " + Ixe.rax(Date.get(5, false, Date.selected_time));
            month_str = "MONTH " + Ixe.rax(Date.get(6, false, Date.selected_time));
            year_str = "YEAR " + Ixe.rax(Date.get(7, true, Date.selected_time));
        } else {
            long day_of_time = Date.selected_time / 131072L;
            day_str = "Day " + Ixe.rax(IxeDate.day_of_month(day_of_time));
            week_str = "Week " + Ixe.rax(IxeDate.week_of_month(day_of_time));
            month_str = "Month " + Ixe.rax(IxeDate.month_of_year(day_of_time));
            year_str = "Year " + Ixe.rax(IxeDate.year_of_time(day_of_time));
        }
        this.pane.setTitleAt(3, day_str);
        this.pane.setTitleAt(2, week_str);
        this.pane.setTitleAt(1, month_str);
        this.pane.setTitleAt(0, year_str);
    }

    private boolean must_update_data() {
        for (int i = 0; i < this.tabs.length; ++i) {
            if (!this.tabs[i].request_update) continue;
            return true;
        }
        return false;
    }

    private void update_data() {
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].update_data();
        }
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
        this.update_size(this.getWidth());
    }

    private void init_tab_pane() {
        this.tabs[3] = new DayTab(this);
        this.tabs[2] = new WeekTab(this);
        this.tabs[1] = new MonthTab(this);
        this.tabs[0] = new YearTab(this);
        this.pane.addTab("", null, this.tabs[0], "Year schedule");
        this.pane.addTab("", null, this.tabs[1], "Month schedule");
        this.pane.addTab("", null, this.tabs[2], "Week schedule");
        this.pane.addTab("", null, this.tabs[3], "Day schedule");
        this.pane.addTab("", null, null, "Clock");
        this.pane.setEnabledAt(4, false);
        this.pane.setMnemonicAt(3, 52);
        this.pane.setMnemonicAt(2, 51);
        this.pane.setMnemonicAt(1, 50);
        this.pane.setMnemonicAt(0, 49);
        this.pane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Window.this.open_date(Window.this.pane.getSelectedIndex());
            }
        });
        this.add((Component)this.pane, "Center");
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        if (this.must_update_data()) {
            this.update_data();
        }
        this.update_clock();
    }

    private void update_clock() {
        this.pane.setTitleAt(4, IxeTime.str_clock(Date.current_time));
    }

    @Override
    public void save(boolean change_file) {
        int returnVal;
        this.note.put();
        if ((this.file == null || change_file) && (returnVal = fc.showSaveDialog(this)) == 0) {
            this.file = fc.getSelectedFile();
        }
        if (this.file != null) {
            if (!this.file.getName().endsWith(".list")) {
                this.file = new File(this.file.getAbsolutePath() + ".list");
            }
            try {
                Lists list = new Lists();
                this.note_to_map(list, 0, this.abs_year_note);
                this.note_to_map(list, 1, this.abs_month_note);
                this.note_to_map(list, 2, this.year_note);
                this.note_to_map(list, 3, this.month_note);
                this.note_to_map(list, 4, this.week_note);
                this.note_to_map(list, 5, this.day_note);
                this.fields_to_map(list, 6);
                this.logs_to_map(list, 7);
                ListEncoder.open(this.file, false, list);
            }
            catch (Exception e) {
                IxeDialog.error("Cannot save " + this.file + "\n" + e.getMessage());
            }
        }
    }

    private void note_to_map(Lists list, int index, HashMap<Long, String> note) {
        ListPage page = new ListPage(index);
        list.add_page(page);
        for (Map.Entry<Long, String> entry : note.entrySet()) {
            String val = entry.getValue();
            if (val == null || val.isEmpty()) continue;
            page.put((long)entry.getKey(), val);
        }
    }

    private void fields_to_map(Lists list, int index) {
        int i;
        ListPage page = new ListPage(index);
        list.add_page(page);
        String[] name = new String[this.log_types.size()];
        int[] rgb = new int[this.log_types.size()];
        for (int i2 = 0; i2 < this.log_types.size(); ++i2) {
            LogType type = this.log_types.get(i2);
            name[i2] = type.name;
            rgb[i2] = type.rgb;
        }
        page.put(0L, name);
        page.put(1L, rgb);
        String[][] location = new String[12][this.log_locations.size()];
        for (i = 0; i < this.log_locations.size(); ++i) {
            LogLocation l = this.log_locations.get(i);
            location[0][i] = l.name;
            location[1][i] = l.comment;
            for (int j = 0; j < 5; ++j) {
                location[j * 2 + 2][i] = l.key[j];
                location[j * 2 + 3][i] = l.value[j];
            }
        }
        for (i = 0; i < location.length; ++i) {
            page.put((long)(2 + i), location[i]);
        }
    }

    private void logs_to_map(Lists list, int index) {
        ListPage page = new ListPage(index);
        list.add_page(page);
        String[] title = new String[this.logs.size()];
        boolean[] active = new boolean[this.logs.size()];
        long[] time_start = new long[this.logs.size()];
        long[] time_end = new long[this.logs.size()];
        int[] location = new int[this.logs.size()];
        int[] type = new int[this.logs.size()];
        String[] description = new String[this.logs.size()];
        for (int i = 0; i < this.logs.size(); ++i) {
            Log l = this.logs.get(i);
            if (l == null) continue;
            title[i] = l.title;
            active[i] = l.active;
            time_start[i] = l.time_start;
            time_end[i] = l.time_end;
            location[i] = l.location == null ? -1 : this.log_locations.indexOf(l.location);
            type[i] = l.type == null ? -1 : this.log_types.indexOf(l.type);
            description[i] = l.description;
        }
        page.put(0L, title);
        page.put(1L, active);
        page.put(2L, time_start);
        page.put(3L, time_end);
        page.put(4L, location);
        page.put(5L, type);
        page.put(6L, description);
    }

    public void load(boolean change_file) {
        int returnVal;
        if ((this.file == null || change_file) && (returnVal = fc.showSaveDialog(this)) == 0) {
            this.file = fc.getSelectedFile();
        }
        if (this.file != null) {
            if (!this.file.getName().endsWith(".list")) {
                this.file = new File(this.file.getAbsolutePath() + ".list");
            }
            if (this.file.exists()) {
                try {
                    Lists list = ListDecoder.open(this.file);
                    this.map_to_note(list, 0, this.abs_year_note);
                    this.map_to_note(list, 1, this.abs_month_note);
                    this.map_to_note(list, 2, this.year_note);
                    this.map_to_note(list, 3, this.month_note);
                    this.map_to_note(list, 4, this.week_note);
                    this.map_to_note(list, 5, this.day_note);
                    this.map_to_fields(list, 6);
                    this.map_to_logs(list, 7);
                    this.tabs[3].update_fields();
                    this.note.unset();
                    this.open_date(3, Date.current_time);
                }
                catch (Exception e) {
                    IxeDialog.error("Cannot load " + this.file + "\n" + e.getMessage());
                    this.clear();
                }
            }
        }
    }

    private void map_to_note(Lists list, int index, HashMap<Long, String> note) {
        note.clear();
        ListPage page = list.get_page(index);
        if (page == null) {
            return;
        }
        for (Map.Entry<Long, ListVal> entry : page.map.entrySet()) {
            note.put(entry.getKey(), entry.getValue().str());
        }
    }

    private void map_to_fields(Lists list, int index) {
        int i;
        this.log_types.clear();
        this.log_locations.clear();
        ListPage page = list.get_page(index);
        if (page == null) {
            return;
        }
        String[] name = ListVals.getStrings(page.map.get((Object)Long.valueOf((long)0L)).bytes);
        int[] rgb = ListVals.getInts(page.map.get((Object)Long.valueOf((long)1L)).bytes);
        for (int i2 = 0; i2 < name.length - 1; ++i2) {
            this.log_types.add(new LogType(name[i2], rgb[i2]));
        }
        String[] name2 = ListVals.getStrings(page.map.get((Object)Long.valueOf((long)2L)).bytes);
        String[] comment = ListVals.getStrings(page.map.get((Object)Long.valueOf((long)3L)).bytes);
        String[][] fields = new String[10][];
        for (i = 0; i < fields.length; ++i) {
            fields[i] = ListVals.getStrings(page.map.get((Object)Long.valueOf((long)(4L + (long)i))).bytes);
        }
        for (i = 0; i < name2.length - 1; ++i) {
            LogLocation l = new LogLocation(name2[i], comment[i]);
            for (int j = 0; j < fields.length / 2; ++j) {
                l.set_field(j, fields[j * 2 + 0][i], fields[j * 2 + 1][i]);
            }
            this.log_locations.add(l);
        }
    }

    private void map_to_logs(Lists list, int index) {
        this.logs.clear();
        ListPage page = list.get_page(index);
        if (page == null) {
            return;
        }
        String[] title = ListVals.getStrings(page.map.get((Object)Long.valueOf((long)0L)).bytes);
        boolean[] active = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)1L)).bytes);
        long[] time_start = ListVals.getLongs(page.map.get((Object)Long.valueOf((long)2L)).bytes);
        long[] time_end = ListVals.getLongs(page.map.get((Object)Long.valueOf((long)3L)).bytes);
        int[] location = ListVals.getInts(page.map.get((Object)Long.valueOf((long)4L)).bytes);
        int[] type = ListVals.getInts(page.map.get((Object)Long.valueOf((long)5L)).bytes);
        String[] description = ListVals.getStrings(page.map.get((Object)Long.valueOf((long)6L)).bytes);
        for (int i = 0; i < time_start.length; ++i) {
            Log l = new Log(title[i], active[i], time_start[i], time_end[i], location[i] < 0 || location[i] >= this.log_locations.size() ? null : this.log_locations.get(location[i]), type[i] < 0 || type[i] >= this.log_types.size() ? null : this.log_types.get(type[i]), description[i]);
            this.logs.add(l);
        }
    }

    public void auto() {
        this.auto = new File("auto.list");
        if (this.auto.exists() && this.auto.isFile()) {
            this.file = this.auto;
            this.load(false);
        }
    }

    public void set_time_format(boolean time_format) {
        this.time_format = time_format;
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].set_time_format(time_format);
        }
        this.update_date();
    }

    public void date_reset() {
        this.tabs[this.pane.getSelectedIndex()].reset_date();
    }

    public void date_dec(int tab) {
        this.tabs[tab].decrement_date();
        this.update_data();
    }

    public void date_inc(int tab) {
        this.tabs[tab].increment_date();
        this.update_data();
    }

    public void toggle_notes(boolean toggle) {
        this.note.setVisible(toggle);
    }

    public void toggle_editor(boolean toggle) {
        this.tabs[3].toggle_editor(toggle);
    }

    public int log_index(long time) {
        int l = 0;
        int r = this.logs.size();
        while (l < r) {
            int m = l + (r - l) / 2;
            if (this.logs.get((int)m).time_start < time) {
                l = m + 1;
                continue;
            }
            r = m;
        }
        return l;
    }

    public void add_log(Log log) {
        this.logs.add(this.log_index(log.time_start), log);
    }

    public void remove_log(Log log) {
        this.logs.remove(log);
    }

    public void remove_all_log(long time_start) {
        long min = time_start / 131072L * 131072L;
        long max = min + 131072L;
        int index = this.log_index(min);
        while (index < this.logs.size() && this.logs.get((int)index).time_start < max) {
            this.logs.remove(index);
        }
    }

    public void clear() {
        this.file = null;
        this.note.unset();
        this.logs.clear();
        this.log_types.clear();
        this.log_locations.clear();
        this.abs_year_note.clear();
        this.abs_month_note.clear();
        this.year_note.clear();
        this.month_note.clear();
        this.week_note.clear();
        this.day_note.clear();
        this.tabs[3].update_fields();
        this.open_date(3, Date.current_time);
    }
}

