/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JPanel;
import pkg_ixe.Ixe;
import pkg_ixe.IxeConst;
import pkg_log.Log;

public class ScheduleBar
extends JPanel {
    private int hour_nb = 32;
    private ScheduleBarBlock[] blocks = new ScheduleBarBlock[this.hour_nb];

    public ScheduleBar() {
        this.setPreferredSize(new Dimension(15, 0));
        for (int i = 0; i < this.hour_nb; ++i) {
            this.blocks[i] = new ScheduleBarBlock();
        }
    }

    public void update_data(ArrayList<Log> data, int start, long day_of_time) {
        int i;
        for (i = 0; i < this.hour_nb; ++i) {
            this.blocks[i].range = 0;
        }
        if (data == null || data.isEmpty() || start < 0) {
            this.setVisible(false);
            return;
        }
        this.setVisible(start < data.size() && data.get((int)start).time_start / 131072L == day_of_time);
        for (i = start; i < data.size(); ++i) {
            Log l = data.get(i);
            if (l.time_start / 131072L != day_of_time) break;
            int hour_start = Ixe.clamp((int)(l.time_start % 131072L / 4096L), 0, 31);
            int hour_end = Ixe.clamp((int)((l.time_end % 131072L - 1L) / 4096L), hour_start, 31);
            Color color = IxeConst.swing_DEFAULT_COLOR;
            if (l.type != null) {
                color = l.type.get_color();
            }
            for (int j = hour_start; j <= hour_end; ++j) {
                if (this.blocks[j].colors.size() <= this.blocks[j].range) {
                    this.blocks[j].colors.add(color);
                } else {
                    this.blocks[j].colors.set(this.blocks[j].range, color);
                }
                ++this.blocks[j].range;
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        double block_height = (double)height / (double)this.hour_nb;
        for (int i = 0; i < this.hour_nb; ++i) {
            double log_height = block_height / (double)this.blocks[i].range;
            if (this.blocks[i].range == 0) {
                g.setColor(IxeConst.swing_DEFAULT_COLOR);
                g.fillRect(0, (int)(block_height * (double)i), width, (int)(block_height * (double)(i + 1)));
            }
            for (int j = 0; j < this.blocks[i].range; ++j) {
                g.setColor(this.blocks[i].colors.get(j));
                g.fillRect(0, (int)(block_height * (double)i + log_height * (double)j), width, (int)(block_height * (double)i + log_height * (double)(j + 1)));
            }
        }
    }

    private class ScheduleBarBlock {
        ArrayList<Color> colors = new ArrayList();
        int range = 0;

        private ScheduleBarBlock() {
        }
    }
}

