/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pkg_ixe.Ixe;
import pkg_ixe.IxeDate;
import pkg_log.Log;

public class RepeatDialog {
    private int count;
    private int day_of_week;
    private JButton btn_less2 = new JButton("\u2b69\u2b69");
    private JButton btn_less1 = new JButton("\u2b69");
    private JButton btn_more1 = new JButton("\u2b67");
    private JButton btn_more2 = new JButton("\u2b67\u2b67");
    private JLabel lbl_count = new JLabel("", 0);
    private JPanel pnl_content;
    private int range_min = 0;
    private int range_max = 365;
    private JCheckBox[] box = new JCheckBox[9];

    public RepeatDialog() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new BorderLayout());
        this.pnl_content = new JPanel(new BorderLayout());
        JPanel pnl_north = new JPanel(new GridLayout(1, 5));
        JPanel pnl_south = new JPanel(new GridLayout(1, 9));
        this.btn_less2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepeatDialog.this.update_week(-8);
            }
        });
        this.btn_less1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepeatDialog.this.update_week(-1);
            }
        });
        this.btn_more1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepeatDialog.this.update_week(1);
            }
        });
        this.btn_more2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepeatDialog.this.update_week(8);
            }
        });
        pnl_north.add(this.btn_less2);
        pnl_north.add(this.btn_less1);
        pnl_north.add(this.lbl_count);
        pnl_north.add(this.btn_more1);
        pnl_north.add(this.btn_more2);
        pnl_north.setBorder(BorderFactory.createTitledBorder("Day range"));
        for (int i = 0; i < this.box.length; ++i) {
            String name = "" + (i - 1);
            this.box[i] = new JCheckBox(i == 0 ? "ALL" : name);
            pnl_south.add(this.box[i]);
        }
        this.box[0].addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                for (int i = 1; i < RepeatDialog.this.box.length; ++i) {
                    RepeatDialog.this.box[i].setSelected(RepeatDialog.this.box[0].isSelected());
                }
            }
        });
        pnl_south.setBorder(BorderFactory.createTitledBorder("Days of Week"));
        panel.add((Component)pnl_north, "North");
        panel.add((Component)pnl_south, "Center");
        panel2.add((Component)panel, "West");
        this.pnl_content.add((Component)panel2, "Center");
    }

    private void update_week(int diff) {
        this.count = Ixe.clamp(this.count + diff, this.range_min, this.range_max);
        this.lbl_count.setText("" + this.count);
        this.btn_less2.setEnabled(this.count > this.range_min);
        this.btn_less1.setEnabled(this.count > this.range_min);
        this.btn_more1.setEnabled(this.count < this.range_max);
        this.btn_more2.setEnabled(this.count < this.range_max);
        for (int i = 0; i < 8; ++i) {
            this.box[i + 1].setEnabled((i - this.day_of_week + 8) % 8 < this.count);
        }
    }

    public void open(Log log) {
        this.count = 0;
        for (int i = 0; i < this.box.length; ++i) {
            this.box[i].setSelected(false);
        }
        this.day_of_week = IxeDate.day_of_week(log.time_start / 131072L + 1L);
        this.update_week(0);
        int result = JOptionPane.showConfirmDialog(null, this.pnl_content, "Repeat Editor", 2, -1);
        if (result != 0) {
            this.count = 0;
        }
    }

    public int get_count() {
        return this.count;
    }

    public boolean repeat(int it) {
        if (it >= this.count) {
            return false;
        }
        int day_of_week = (this.day_of_week + it) % 8;
        return this.box[day_of_week + 1].isSelected();
    }
}

