/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import pkg_ixe.Ixe;
import pkg_ixe.IxeTime;
import pkg_layout_tab_cell.LocationCell;
import pkg_layout_tab_cell.TypeCell;
import pkg_log.Log;
import pkg_log.LogLocation;
import pkg_log.LogType;

public class LogTableModel
extends AbstractTableModel {
    private String[] columns = new String[]{"Done", "Title", "Start", "End", "Location", "Type", "Description"};
    private Object[] classes = new Object[]{new Boolean(false), new String(""), new String(""), new String(""), new LogLocation(""), new LogType("", 0), new String("")};
    public int col_nb = this.columns.length;
    private boolean[] editable = new boolean[]{true, true, true, true, true, true, true};
    private ArrayList<Log> data = new ArrayList();
    private LocationCell location;
    private TypeCell type;

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = null;
        if (row < 0 || row >= this.data.size()) {
            return null;
        }
        Log l = this.data.get(row);
        switch (column) {
            case 0: {
                value = !l.active;
                break;
            }
            case 1: {
                value = l.title;
                break;
            }
            case 2: {
                value = IxeTime.str_clock(l.time_start);
                break;
            }
            case 3: {
                value = IxeTime.str_clock(l.time_end);
                break;
            }
            case 4: {
                value = l.location;
                break;
            }
            case 5: {
                value = l.type;
                break;
            }
            case 6: {
                value = l.description;
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.data.isEmpty() || row < 0 || row >= this.data.size()) {
            return;
        }
        Log l = this.data.get(row);
        switch (column) {
            case 0: {
                l.active = (Boolean)value == false;
                break;
            }
            case 1: {
                l.title = (String)value;
                break;
            }
            case 2: {
                long start = l.time_start;
                try {
                    start = Ixe.clamp(IxeTime.parse((String)value), 0L, 131072L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                l.time_start = start + (l.time_start - l.time_start % 131072L);
                if (l.time_end >= l.time_start) break;
                l.time_end = l.time_start;
                break;
            }
            case 3: {
                long end = l.time_end;
                try {
                    end = Ixe.clamp(IxeTime.parse((String)value), 0L, 131072L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                l.time_end = end + (l.time_end - l.time_end % 131072L);
                if (l.time_end >= l.time_start) break;
                l.time_end = l.time_start;
                break;
            }
            case 4: {
                l.location = (LogLocation)value;
                this.location.set_selected(l.location);
                break;
            }
            case 5: {
                l.type = (LogType)value;
                this.type.set_selected(l.type);
                break;
            }
            case 6: {
                l.description = (String)value;
            }
        }
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column >= 0 && column < this.editable.length && this.editable[column] && (column == 0 || (Boolean)this.getValueAt(row, 0) == false);
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.classes[columnIndex].getClass();
    }

    public ArrayList<Log> get_data() {
        return this.data;
    }

    public Log get_log_at(int index) {
        if (index >= 0 && index < this.data.size()) {
            return this.data.get(index);
        }
        return null;
    }

    public void ref(LocationCell location, TypeCell type) {
        this.location = location;
        this.type = type;
    }
}

