/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LimitTextField
extends JTextField {
    private int limit;
    private boolean uppercase;

    public LimitTextField(int limit) {
        this(limit, false);
    }

    public LimitTextField(int limit, boolean uppercase) {
        this.limit = limit;
        this.uppercase = uppercase;
    }

    @Override
    protected Document createDefaultModel() {
        return new LimitDocument();
    }

    private class LimitDocument
    extends PlainDocument {
        private LimitDocument() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= LimitTextField.this.limit) {
                super.insertString(offset, LimitTextField.this.uppercase ? str.toUpperCase() : str, attr);
            }
        }
    }
}

