/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import pkg_logic.CalcToken;

public class Calculator {
    private final int[] operator_priority = new int[]{1, 1, 2, 2, 2, 3, 4, 1};
    private final int operator_lenght = this.operator_priority.length;
    private final double[] cst = new double[]{Math.PI, Math.E, 1.618033988749895, 0.5772156649015329, 1.4142135623730951, Math.log(16.0)};
    private final String[] function_names = new String[]{"cos", "sin", "tan", "cosh", "sinh", "tanh", "floor", "round", "ceil", "root", "prime", "ln", "log", "abs"};

    public CalcToken solve(String input) {
        if (input == null || input.isEmpty()) {
            return new CalcToken(" ");
        }
        CalcToken token = new CalcToken("!error!");
        if (!input.contains("\\")) {
            for (int i = 0; i < this.function_names.length; ++i) {
                input = input.replaceAll(this.function_names[i] + "\\(", "\\\\" + this.function_names[i] + "(");
            }
            try {
                token = this._solve(input);
            }
            catch (Exception e) {
                token.set_error(e.getMessage());
            }
        }
        if (token == null) {
            token = new CalcToken(0.0);
        }
        return token;
    }

    private CalcToken _solve(String input) throws Exception {
        if (input.isEmpty()) {
            return new CalcToken(0.0);
        }
        CalcToken first = null;
        CalcToken previous = null;
        for (int i = 0; i < input.length(); ++i) {
            CalcToken token = null;
            char c1 = input.charAt(i);
            if (!this.valid_char(c1)) {
                throw new Exception("!char!");
            }
            if (c1 == '(') {
                int nest = 1;
                int start = i++;
                while (i < input.length()) {
                    char c2 = input.charAt(i);
                    if (c2 == '(') {
                        ++nest;
                    } else if (c2 == ')') {
                        if (--nest == 0) {
                            token = this._solve(input.substring(start + 1, i));
                            break;
                        }
                    } else if (i == input.length() - 1 && nest == 1) {
                        nest = 0;
                        token = this._solve(input.substring(start + 1, i + 1));
                    }
                    ++i;
                }
                if (nest != 0) {
                    throw new Exception("!nest!");
                }
            } else {
                boolean numeric = this.numeric(c1);
                boolean decimal_point = c1 == '.';
                boolean function = c1 == '\\';
                int operator = this.operation(c1);
                int constant = this.constant(c1);
                if (constant != -1) {
                    token = new CalcToken(this.cst[constant]);
                } else if (operator != -1) {
                    if (operator != 6 && i == input.length() - 1) {
                        throw new Exception("!operator!");
                    }
                    token = new CalcToken(operator);
                } else if (function) {
                    String substring = input.substring(i + 1);
                    boolean match = false;
                    for (int j = 0; j < this.function_names.length; ++j) {
                        if (!substring.startsWith(this.function_names[j])) continue;
                        token = new CalcToken(this.operator_lenght + j);
                        match = true;
                        i += this.function_names[j].length();
                        break;
                    }
                    if (!match) {
                        throw new Exception("!function name!");
                    }
                } else if (numeric || decimal_point) {
                    for (int j = i + 1; j <= input.length(); ++j) {
                        int num_c;
                        int n = num_c = j < input.length() ? (int)input.charAt(j) : 32;
                        if (num_c == 46 && !decimal_point) {
                            decimal_point = true;
                            continue;
                        }
                        if (j != input.length() && this.numeric(input.charAt(j))) continue;
                        if (decimal_point && j == i + 1) {
                            throw new Exception("!dot!");
                        }
                        token = new CalcToken(this.parse_value(input.substring(i, j)));
                        i = j - 1;
                        break;
                    }
                }
            }
            if (token == null) continue;
            if (first == null) {
                first = token;
            } else if (token.get_operator() == 6 && previous != null && previous.get_operator() == -1) {
                CalcToken token2 = new CalcToken(5);
                token2.set_previous(previous);
                previous.set_next(token2);
                token.set_previous(token2);
                token2.set_next(token);
            } else {
                token.set_previous(previous);
                previous.set_next(token);
            }
            previous = token;
        }
        int max_priority = this.operator_priority[6];
        for (int i = 0; i <= max_priority; ++i) {
            for (CalcToken token = first; token != null; token = token.get_next()) {
                CalcToken token_right;
                CalcToken token_right2;
                if (token.get_operator() >= this.operator_lenght) {
                    token_right2 = token.get_next();
                    if (token_right2 == null || !token_right2.check()) {
                        throw new Exception("!function arg!");
                    }
                    token_right2.set_value(this.operate(token.get_operator() - this.operator_lenght, token_right2.get_value()));
                    CalcToken token_root = token.get_previous();
                    if (token_root != null) {
                        token_root.set_next(token_right2);
                        token_right2.set_previous(token_root);
                    } else {
                        token_right2.set_previous(null);
                        first = token_right2;
                    }
                    token.set_previous(null);
                    token.set_next(null);
                    token = token_right2;
                    continue;
                }
                if (token.get_operator() == 6 && i == max_priority) {
                    boolean sign = true;
                    for (token_right2 = token.get_next(); token_right2 != null && token_right2.get_operator() == 6; token_right2 = token_right2.get_next()) {
                        sign = !sign;
                    }
                    if (token_right2 == null || !token_right2.check()) {
                        throw new Exception("!right operand!");
                    }
                    token_right2.set_value((double)(sign ? -1 : 1) * token_right2.get_value());
                    CalcToken token_root = token.get_previous();
                    if (token_root != null) {
                        token_root.set_next(token_right2);
                        token_right2.set_previous(token_root);
                    } else {
                        token_right2.set_previous(null);
                        first = token_right2;
                    }
                    token.set_previous(null);
                    token.set_next(null);
                    token = token_right2;
                    continue;
                }
                if (token.get_operator() == -1 || i != this.operator_priority[token.get_operator()]) continue;
                CalcToken token_left = token.get_previous();
                if (token_left == null || !token_left.check()) {
                    throw new Exception("!left operand!");
                }
                boolean sign = false;
                for (token_right = token.get_next(); token_right != null && token_right.get_operator() == 6; token_right = token_right.get_next()) {
                    sign = !sign;
                }
                if (token_right == null || !token_right.check()) {
                    throw new Exception("!right operand!");
                }
                token_right.set_value(this.operate(token.get_operator(), token_left.get_value(), (double)(sign ? -1 : 1) * token_right.get_value()));
                CalcToken token_root = token_left.get_previous();
                if (token_root != null) {
                    token_root.set_next(token_right);
                    token_right.set_previous(token_root);
                } else {
                    token_right.set_previous(null);
                    first = token_right;
                }
                token_left.set_previous(null);
                token_left.set_next(null);
                token.set_previous(null);
                token.set_next(null);
                token = token_right;
            }
        }
        if (first.get_next() != null) {
            throw new Exception("!values!");
        }
        return first;
    }

    private boolean valid_char(char c) {
        return this.numeric(c) || this.constant(c) != -1 || this.operation(c) != -1 || c == '.' || c == '\\' || c == '(' || c == ')' || c == 'h' || c == 'H';
    }

    private void print(CalcToken first) {
        for (CalcToken token = first; token != null; token = token.get_next()) {
            System.out.print("[" + token + "]");
        }
        System.out.print("\n");
    }

    private int constant(char c) {
        int constant = -1;
        switch (c) {
            case '\u03c0': {
                constant = 0;
                break;
            }
            case '\u03b5': {
                constant = 1;
                break;
            }
            case '\u03a6': {
                constant = 2;
                break;
            }
            case '\u03b3': {
                constant = 3;
                break;
            }
            case '\u25f8': {
                constant = 4;
            }
        }
        return constant;
    }

    private int operation(char c) {
        int operator = -1;
        switch (c) {
            case '^': {
                operator = 0;
                break;
            }
            case '\u221a': {
                operator = 1;
                break;
            }
            case '%': {
                operator = 2;
                break;
            }
            case '*': {
                operator = 3;
                break;
            }
            case '/': {
                operator = 4;
                break;
            }
            case '+': {
                operator = 5;
                break;
            }
            case '-': {
                operator = 6;
                break;
            }
            case 'H': 
            case 'h': {
                operator = 7;
            }
        }
        return operator;
    }

    private boolean numeric(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private int digit(char c) {
        int d = -1;
        if (c >= '0' && c <= '9') {
            d = c - 48;
        } else if (c >= 'a' && c <= 'f') {
            d = c - 97 + 10;
        } else if (c >= 'A' && c <= 'F') {
            d = c - 65 + 10;
        }
        return d;
    }

    private double parse_value(String value) throws Exception {
        double digit;
        int i;
        double d = 0.0;
        double pow = 1.0;
        int split = value.indexOf(46);
        if (split == -1) {
            split = value.length();
        }
        if (split != 0) {
            for (i = split - 1; i >= 0; --i) {
                digit = this.digit(value.charAt(i));
                d += digit * pow;
                pow *= 16.0;
            }
        }
        pow = 0.0625;
        for (i = split + 1; i < value.length(); ++i) {
            digit = this.digit(value.charAt(i));
            d += digit * pow;
            pow /= 16.0;
        }
        if (Math.abs(d) == Double.POSITIVE_INFINITY) {
            throw new Exception("!too big!");
        }
        return d;
    }

    private double operate(int operation, double term) throws Exception {
        switch (operation) {
            case 0: {
                term = Math.cos(term);
                break;
            }
            case 1: {
                term = Math.sin(term);
                break;
            }
            case 2: {
                term = Math.tan(term);
                break;
            }
            case 3: {
                term = Math.cosh(term);
                break;
            }
            case 4: {
                term = Math.sinh(term);
                break;
            }
            case 5: {
                term = Math.tanh(term);
                break;
            }
            case 6: {
                term = Math.floor(term);
                break;
            }
            case 7: {
                term = Math.round(term);
                break;
            }
            case 8: {
                term = Math.ceil(term);
                break;
            }
            case 9: {
                term = this.longest_root(term);
                break;
            }
            case 10: {
                term = this.closest_prime(term);
                break;
            }
            case 11: {
                term = Math.log(term);
                break;
            }
            case 12: {
                term = Math.log(term) / this.cst[5];
                break;
            }
            case 13: {
                term = Math.abs(term);
            }
        }
        if (Math.abs(term) == Double.POSITIVE_INFINITY) {
            throw new Exception("!too big!");
        }
        return term;
    }

    private double operate(int operation, double left, double right) throws Exception {
        switch (operation) {
            case 0: {
                left = Math.pow(left, right);
                break;
            }
            case 1: {
                if (right == 0.0 || left < 0.0) {
                    throw new Exception("!root!");
                }
                left = Math.pow(left, 1.0 / right);
                break;
            }
            case 2: {
                left %= right;
                break;
            }
            case 3: {
                left *= right;
                break;
            }
            case 4: {
                left /= right;
                break;
            }
            case 5: {
                left += right;
                break;
            }
            case 6: {
                left -= right;
                break;
            }
            case 7: {
                left *= Math.pow(16.0, right);
            }
        }
        if (Math.abs(left) == Double.POSITIVE_INFINITY) {
            throw new Exception("!too big!");
        }
        return left;
    }

    public double closest_prime(double term) {
        if (term > 1.0) {
            long i;
            long t = (long)term;
            if (this.is_prime(t)) {
                return t;
            }
            if (t % 2L == 0L) {
                ++t;
            }
            long l = 0L;
            for (i = t; i >= 1L; i -= 2L) {
                if (!this.is_prime(i)) continue;
                l = i;
                break;
            }
            for (i = t + 1L; i < t + t - l; i += 2L) {
                if (!this.is_prime(i)) continue;
                l = i;
                break;
            }
            return l;
        }
        return 0.0;
    }

    private boolean is_prime(long prime) {
        if (prime == 2L || prime == 3L || prime == 5L || prime == 7L || prime == 11L || prime == 13L) {
            return true;
        }
        if (prime == 1L || prime % 2L == 0L || prime % 3L == 0L || prime % 5L == 0L || prime % 7L == 0L || prime % 11L == 0L || prime % 13L == 0L) {
            return false;
        }
        long odd = prime / 2L;
        if (odd % 2L == 0L) {
            ++odd;
        }
        for (long i = odd; i > 13L; i -= 2L) {
            if (prime % i != 0L) continue;
            return false;
        }
        return true;
    }

    public double longest_root(double term) {
        long t = (long)term;
        if (this.is_prime(t)) {
            return 0.0;
        }
        int i = 2;
        while ((long)i < t) {
            long p = (long)Math.pow(t, 1.0 / (double)i);
            if (t == this.int_pow(p, i)) {
                return i;
            }
            ++i;
        }
        return 0.0;
    }

    private long int_pow(long p, long e) {
        long pow = p;
        for (long i = 1L; i < e; ++i) {
            pow *= p;
        }
        return pow;
    }
}

