/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

public class CalcToken {
    private final String[] names = new String[]{"^", "\u221a", "%", "*", "/", "+", "-", "h", "cos", "sin", "tan", "cosh", "sinh", "tanh", "floor", "round", "ceil", "root", "prime", "ln", "log", "abs"};
    public static final int CALC_TOKEN_OPERATION_SUBSTRACTION = 6;
    private String error = "";
    private double value = 0.0;
    private int operator = -1;
    private CalcToken next = null;
    private CalcToken previous = null;

    public CalcToken(int operator) {
        this.operator = operator;
    }

    public CalcToken(String error) {
        this.error = error;
    }

    public CalcToken(double value) {
        this.value = value;
    }

    public CalcToken get_next() {
        return this.next;
    }

    public void set_next(CalcToken next) {
        this.next = next;
    }

    public CalcToken get_previous() {
        return this.previous;
    }

    public void set_previous(CalcToken previous) {
        this.previous = previous;
    }

    public double get_value() {
        return this.value;
    }

    public void set_value(double value) {
        this.value = value;
    }

    public int get_operator() {
        return this.operator;
    }

    public void set_operator(int operator) {
        this.operator = operator;
    }

    public String get_error() {
        return this.error;
    }

    public boolean check() {
        return this.error.isEmpty() && this.operator == -1;
    }

    public String toString() {
        return this.toString(16);
    }

    public String toString(int radix) {
        return "" + (this.error.isEmpty() ? (this.operator == -1 ? this.value_str(radix) : this.operator_str()) : this.error);
    }

    private String value_str(int radix) {
        if (this.value == 0.0) {
            return "0";
        }
        boolean sign = this.value < 0.0;
        double v = sign ? -this.value : this.value;
        int primary_digit = (int)Math.floor(Math.log(v) / Math.log(radix));
        String str = sign ? "-" : "";
        String scientific_str = "";
        int nb_digits = 20 - str.length();
        double pow = Math.pow(radix, primary_digit);
        if (primary_digit > nb_digits || primary_digit < -nb_digits) {
            scientific_str = "H" + this.scientific_value(primary_digit, radix);
            nb_digits -= scientific_str.length();
            v /= pow;
            pow = 1.0;
            primary_digit = 0;
        } else if (this.value < 1.0) {
            pow = 1.0;
            primary_digit = 0;
        }
        nb_digits = Math.max(nb_digits, 1);
        for (int i = 0; i < nb_digits; ++i) {
            int digit = (int)(v / pow);
            str = str + this.digit_char(digit);
            if ((v -= (pow /= (double)radix) * (double)digit) == 0.0 && (primary_digit < 0 || i - primary_digit > 0)) break;
            if (primary_digit - i != 0) continue;
            str = str + ".";
        }
        return str + scientific_str;
    }

    private String scientific_value(int value, int radix) {
        if (value == 0) {
            return "0";
        }
        boolean sign = value < 0;
        double v = sign ? (double)(-value) : (double)value;
        int primary_digit = (int)(Math.log(v) / Math.log(radix));
        String str = sign ? "-" : "";
        for (double pow = Math.pow(radix, primary_digit); pow >= 1.0; pow /= (double)radix) {
            int digit = (int)(v / pow);
            v -= pow * (double)digit;
            str = str + this.digit_char(digit);
        }
        return str;
    }

    private char digit_char(int digit) {
        return (char)(digit >= 10 ? 97 + (digit - 10) : 48 + digit);
    }

    private String operator_str() {
        return this.operator >= 0 && this.operator < this.names.length ? this.names[this.operator] : "?";
    }

    public void set_error(String error) {
        this.error = error;
    }
}

