/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pkg_ixe.Ixe;
import pkg_logic.CalcToken;
import pkg_logic.Calculator;

public class WindowContent
extends JPanel {
    private Calculator calculator = new Calculator();
    public int next_representation_radix;
    private int representation_radix = this.next_representation_radix = 16;
    private String[] key_titles = new String[]{"Clear", "Check", "cos", "sin", "tan", "\u2191", "\u2193", "cosh", "sinh", "tanh", "floor", "round", "ceil", "root", "prime", "\u03c0", "\u03b5", "\u03a6", "\u03b3", "\u25f8", "d", "e", "f", "(", ")", "a", "b", "c", "ln", "log", "7", "8", "9", "/", "%", "4", "5", "6", "*", "^", "1", "2", "3", "-", "\u221a", "0", ".", "abs", "+", "="};
    private JButton[] keyboard = new JButton[this.key_titles.length];
    private int console_max = 100;
    private String[] console = new String[this.console_max];
    private int console_index = 0;
    private int console_line_index = 0;
    private int console_lenght = 0;
    private JTextField line = new JTextField("", 2);
    private JLabel line_result = new JLabel("", 0);
    private int previous_lenght = 10;
    private JLabel[] previous_lines = new JLabel[this.previous_lenght];
    private JLabel[] previous_results = new JLabel[this.previous_lenght];
    private CalcToken[] results = new CalcToken[this.previous_lenght + 1];

    public WindowContent() {
        this.setLayout(new BorderLayout());
        JPanel console_panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        for (int i = 0; i < this.previous_lines.length; ++i) {
            this.previous_lines[i] = new JLabel("", 2);
            c.fill = 2;
            c.gridx = 0;
            c.gridy = i;
            c.weightx = 4.0;
            console_panel.add((Component)this.previous_lines[i], c);
            this.previous_results[i] = new JLabel(" ", 0);
            c.fill = 2;
            c.gridx = 1;
            c.gridy = i;
            c.weightx = 1.0;
            console_panel.add((Component)this.previous_results[i], c);
        }
        c.fill = 2;
        c.gridx = 0;
        c.gridy = this.previous_lines.length;
        c.weightx = 1.0;
        console_panel.add((Component)this.line, c);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = this.previous_lines.length;
        c.weightx = 1.0;
        console_panel.add((Component)this.line_result, c);
        this.add((Component)console_panel, "North");
        this.line_result.setForeground(Color.DARK_GRAY);
        JPanel keys = new JPanel(new GridLayout(this.key_titles.length / 5, 5));
        for (int i = 0; i < this.keyboard.length; ++i) {
            this.keyboard[i] = new JButton(this.key_titles[i]);
            keys.add(this.keyboard[i]);
        }
        this.add((Component)keys, "Center");
        this.listener_logic();
        this.focus_line();
    }

    private void console_move_up() {
        if (this.console_lenght == this.console_max) {
            int index = (this.console_index - 1 + this.console_max) % this.console_max;
            if (index != this.console_line_index) {
                this.console_index = index;
            }
        } else {
            --this.console_index;
        }
        this.console_index = Ixe.clamp(this.console_index, 0, this.console_lenght);
        this.line.setText(this.console[this.console_index]);
    }

    private void console_move_down() {
        if (this.console_lenght == this.console_max) {
            int index = (this.console_index + 1 + this.console_max) % this.console_max;
            if (index != this.console_line_index + 1) {
                this.console_index = index;
            }
        } else {
            ++this.console_index;
        }
        this.console_index = Ixe.clamp(this.console_index, 0, this.console_lenght);
        this.line.setText(this.console[this.console_index]);
    }

    private void listener_logic() {
        int it = 0;
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply_control(2);
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply_control(1);
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("cos(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("sin(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("tan(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply_control(3);
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply_control(4);
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("cosh(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("sinh(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("tanh(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("floor(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("round(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("ceil(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("root(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("prime(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("\u03c0");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("\u03b5");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("\u03a6");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("\u03b3");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("\u25f8");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("d");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("e");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("f");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply(")");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("a");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("b");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("c");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("ln(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("log(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("7");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("8");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("9");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("/");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("%");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("4");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("5");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("6");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("*");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("^");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("1");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("2");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("3");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("-");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("\u221a");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("0");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply(".");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("abs(");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply("+");
            }
        });
        this.keyboard[it++].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowContent.this.apply_control(0);
            }
        });
    }

    private void apply_control(int control) {
        switch (control) {
            case 0: {
                this.evaluate(true);
                break;
            }
            case 1: {
                this.evaluate(false);
                break;
            }
            case 2: {
                this.line.setText("");
                break;
            }
            case 3: {
                this.console_move_up();
                break;
            }
            case 4: {
                this.console_move_down();
            }
        }
        this.focus_line();
    }

    private void apply(String str) {
        int caret = this.line.getCaretPosition();
        this.line.setText(this.line.getText().substring(0, caret) + str + this.line.getText().substring(caret));
        this.line.setCaretPosition(caret + str.length());
        this.focus_line();
    }

    private void focus_line() {
        this.line.requestFocus();
    }

    private void evaluate(boolean perform) {
        this.console[this.console_line_index] = this.line.getText();
        if (this.console_lenght < this.console_max) {
            ++this.console_lenght;
        }
        this.console_index = this.console_line_index = (this.console_line_index + 1) % this.console_max;
        CalcToken r = this.calculator.solve(this.line.getText());
        String string = this.console[this.console_line_index] = r.check() ? r.toString(16) : "";
        if (perform) {
            this.line.setText(this.console[this.console_line_index]);
        }
        this.update_previous_lines(r);
    }

    private void update_previous_lines(CalcToken result) {
        int i;
        int index = this.console_line_index;
        for (i = this.previous_lines.length - 1; i >= 0; --i) {
            if (--index == -1 && this.console_max == this.console_lenght) {
                index = (index + this.console_max) % this.console_max;
            }
            this.previous_lines[i].setText(index >= 0 ? this.console[index] : "");
        }
        for (i = 0; i < this.previous_results.length - 1; ++i) {
            this.results[i] = this.results[i + 1];
            this.previous_results[i].setText(this.previous_results[i + 1].getText());
        }
        this.results[this.previous_results.length - 1] = result;
        this.previous_results[this.previous_results.length - 1].setText(result.toString(this.representation_radix));
    }

    public void update() {
        CalcToken token = this.calculator.solve(this.line.getText());
        this.line_result.setText(token == null ? "" : token.toString(this.representation_radix));
        if (this.representation_radix != this.next_representation_radix) {
            this.representation_radix = this.next_representation_radix;
            this.update_result_representation();
        }
    }

    private void update_result_representation() {
        for (int i = 0; i < this.results.length; ++i) {
            if (this.results[i] == null) continue;
            this.previous_results[i].setText(this.results[i].toString(this.representation_radix));
        }
    }
}

